/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.core.Component;
import cn.zkdcloud.util.HttpUtil;
import cn.zkdcloud.util.JsonUtil;
import cn.zkdcloud.util.WeChatUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class Oauth2AuthorizeComponent
implements Component {
    private static Logger logger = Logger.getLogger(Oauth2AuthorizeComponent.class);
    public static Oauth2AuthorizeComponent authorizeComponent;
    public static String SNSAPI_BASE_URL;
    public static String SNSAPI_USERINFO_URL;
    public static String GET_USER_ACCESS_TOKEN;
    public static String REFRESH_ACCESS_TOKEN;
    public static String GET_USER_INFO;
    private static String CHECK_ACCESS_TOKEN;

    @Override
    public void init() {
    }

    private Oauth2AuthorizeComponent() {
    }

    public void setSnsapiUrl(String redirect_uri, String state) {
        try {
            redirect_uri = URLEncoder.encode(redirect_uri, "UTF-8");
            SNSAPI_BASE_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeChatUtil.getAppId() + "&redirect_uri=" + redirect_uri + "&response_type=code&scope=snsapi_base&state=" + state + "#wechat_redirect";
            SNSAPI_USERINFO_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + WeChatUtil.getAppId() + "&redirect_uri=" + redirect_uri + "&response_type=code&scope=snsapi_userinfo&state=" + state + "#wechat_redirect";
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String getUserInfo(String code) {
        String accessTokenJson = this.getUserAccessToken(code);
        if (null != accessTokenJson) {
            JSONObject accessToken = JSONObject.parseObject((String)accessTokenJson);
            return this.getUserInfo(accessToken.getString("access_token"), accessToken.getString("openid"));
        }
        return null;
    }

    public String getUserAccessToken(String code) {
        String ret = HttpUtil.doGet(GET_USER_ACCESS_TOKEN + code);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get user access tocken error!");
            return null;
        }
        return ret;
    }

    public String refreshUserAccessToken(String refresh_token) {
        String ret = HttpUtil.doGet(REFRESH_ACCESS_TOKEN + refresh_token);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"refresh user access token fail");
            return null;
        }
        return ret;
    }

    public String getUserInfo(String access_token, String openid) {
        return this.getUserInfo(access_token, openid, "zh_CN");
    }

    public String getUserInfo(String access_token, String openid, String lang) {
        String ret = HttpUtil.doGet(GET_USER_INFO + "access_token=" + access_token + "&openid=" + openid + "&lang=" + lang);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get userinfo fail");
            return null;
        }
        return ret;
    }

    public boolean isEffective(String access_token, String openid) {
        String ret = HttpUtil.doGet(CHECK_ACCESS_TOKEN + "access_token=" + access_token + "&openid=" + openid);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"this access is expire");
            return false;
        }
        return true;
    }

    public static Oauth2AuthorizeComponent getInstance() {
        if (null == authorizeComponent) {
            authorizeComponent = new Oauth2AuthorizeComponent();
        }
        return authorizeComponent;
    }

    static {
        GET_USER_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=" + WeChatUtil.getAppId() + "&secret=" + WeChatUtil.getAppSecret() + "&grant_type=authorization_code&code=";
        REFRESH_ACCESS_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=" + WeChatUtil.getAppId() + "&grant_type=refresh_token&refresh_token=";
        GET_USER_INFO = "https://api.weixin.qq.com/sns/userinfo?";
        CHECK_ACCESS_TOKEN = " https://api.weixin.qq.com/sns/auth?";
    }
}

