/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.annotation.MessageProcess;
import cn.zkdcloud.component.message.AbstractAcceptMessage;
import cn.zkdcloud.component.message.AbstractResponseMessage;
import cn.zkdcloud.core.Component;
import cn.zkdcloud.util.FileUtil;
import cn.zkdcloud.util.StreamUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class MessageComponent
implements Component {
    private static Logger logger = Logger.getLogger(MessageComponent.class);
    public static MessageComponent messageComponent;
    private Map<Method, Class> adapterMap = new HashMap<Method, Class>();

    @Override
    public void init() {
        try {
            List classes = FileUtil.getClassByAnnotion((String)MessageProcess.class.getName());
            this.init(classes);
            logger.info((Object)"message component init finish");
        }
        catch (Exception e) {
            logger.error((Object)"message component init fail!");
            e.printStackTrace();
        }
    }

    private MessageComponent() {
    }

    public void init(List<Class> classes) {
        for (Class clazz : classes) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Class<?>[] paraClazzs = method.getParameterTypes();
                if (paraClazzs == null || 1 != paraClazzs.length || !AbstractAcceptMessage.class.isAssignableFrom(paraClazzs[0])) continue;
                this.adapterMap.put(method, clazz);
            }
        }
    }

    public String doAdapter(AbstractAcceptMessage acceptMessage) {
        Class<?> exceptClass = acceptMessage.getClass();
        AbstractResponseMessage ret = null;
        for (Map.Entry<Method, Class> entry : this.adapterMap.entrySet()) {
            Method tar = entry.getKey();
            try {
                if (exceptClass != tar.getParameterTypes()[0]) continue;
                ret = (AbstractResponseMessage)tar.invoke(entry.getValue().newInstance(), acceptMessage);
                ret.setFromUserName(acceptMessage.getToUserName());
                ret.setToUserName(acceptMessage.getFromUserName());
                if (ret == null) {
                    return "success";
                }
                return StreamUtil.ObjToXml(ret);
            }
            catch (Exception e) {
            }
        }
        logger.info((Object)"no fit method for this request, please check it");
        return "success";
    }

    public String doAdapter(HttpServletRequest request) {
        AbstractAcceptMessage acceptMessage;
        try {
            acceptMessage = AbstractAcceptMessage.prepareMessage(request);
        }
        catch (Exception e) {
            logger.error((Object)(e.getMessage() + "---\u521d\u59cb\u5316\u6d88\u606f\u5931\u8d25"));
            return "success";
        }
        return this.doAdapter(acceptMessage);
    }

    public static MessageComponent getInstance() {
        if (null == messageComponent) {
            messageComponent = new MessageComponent();
        }
        return messageComponent;
    }
}

