/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.component.material.Material;
import cn.zkdcloud.component.material.MaterialArticle;
import cn.zkdcloud.component.material.MaterialType;
import cn.zkdcloud.core.Component;
import cn.zkdcloud.util.AccessToken;
import cn.zkdcloud.util.HttpUtil;
import cn.zkdcloud.util.JsonUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MaterialComponent
implements Component {
    private static Logger logger = Logger.getLogger(MaterialComponent.class);
    public static MaterialComponent materialComponent;
    public static String UPLOAD_TEMP_MATERIAL;
    public static String UPLOAD_PERSISTENT_NEWS;
    public static String UPLOAD_IMG_URL;
    public static String UPLOAD_PERSISTENT_MATERIAL;
    public static String DOWNLOAD_TEMP_MATERIAL;
    public static String DOWNLOAD_PERSISTENT_MATERIAL;
    public static String COUNT_PERSISTENT_MATERIAL;
    public static String LIST_PERSISTENT_MATERIAL;
    public static String UPDATE_PERSISTENT_NEWS_MATERIAL;
    public static String DELETE_PERSISTENT_MATERIAL;

    @Override
    public void init() {
    }

    private MaterialComponent() {
    }

    public String uploadTempMaterial(File file, MaterialType type) {
        String ret = HttpUtil.doPost(UPLOAD_TEMP_MATERIAL + type.toString().toLowerCase(), file);
        if (null == ret) {
            logger.info((Object)"upload temp image fail");
            return null;
        }
        return JSONObject.parseObject((String)ret).getString("media_id");
    }

    public String uploadPersistentMaterial(List<MaterialArticle> articles) {
        return this.uploadPersistentMaterial("{\"articles\":" + JSONObject.toJSONString(articles) + "}");
    }

    public String uploadPersistentMaterial(String articles) {
        String ret = HttpUtil.doPost(UPLOAD_PERSISTENT_NEWS, articles);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"UPLOAD persistent material fail");
            return null;
        }
        return JSONObject.parseObject((String)ret).getString("media_id");
    }

    public String uploadPersistentImage(File file) {
        String ret = HttpUtil.doPost(UPLOAD_IMG_URL, file);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"upload image fail");
            return null;
        }
        return JSONObject.parseObject((String)ret).getString("url");
    }

    public String uploadPersistentMaterial(File file, MaterialType type, String title, String introduction) {
        JSONObject attach = new JSONObject();
        attach.put("title", (Object)title);
        attach.put("introduction", (Object)introduction);
        String ret = HttpUtil.doPost(UPLOAD_PERSISTENT_MATERIAL + type.toString().toLowerCase(), file, attach.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"upload persistent material fail");
            return null;
        }
        return ret;
    }

    public String downloadVideo(String media_id) {
        String ret = HttpUtil.doGet(DOWNLOAD_TEMP_MATERIAL.replace("https", "http") + media_id);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get video resources fail");
            return null;
        }
        return JSONObject.parseObject((String)ret).getString("video_url");
    }

    public File downloadTempMaterial(String media_id, String filePath) {
        return HttpUtil.doGet(DOWNLOAD_TEMP_MATERIAL + media_id, filePath);
    }

    public File downloadTempMaterial(String media_id, String fileDirPath, String suffix) {
        if (!(fileDirPath = fileDirPath.replace("\\", "/")).endsWith("/")) {
            fileDirPath = fileDirPath + "/";
        }
        if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        String filePath = fileDirPath + System.currentTimeMillis() + "." + suffix;
        return HttpUtil.doGet(DOWNLOAD_TEMP_MATERIAL + media_id, filePath);
    }

    public List<MaterialArticle> downloadPersistentNews(String media_id) {
        JSONObject data = new JSONObject();
        data.put("media_id", (Object)media_id);
        String ret = HttpUtil.doPost(DOWNLOAD_PERSISTENT_MATERIAL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get persistent news fail");
            return null;
        }
        List articles = JSONObject.parseObject((String)ret).getJSONArray("news_item").toJavaList(MaterialArticle.class);
        return articles;
    }

    public String downloadPersistentVideo(String media_id) {
        String ret = HttpUtil.doPost(DOWNLOAD_PERSISTENT_MATERIAL, "{\"media_id\":" + media_id + "}");
        if (JsonUtil.isError(ret)) {
            logger.info((Object)"get persistent video fail");
            return null;
        }
        return JSONObject.parseObject((String)ret).getString("down_url");
    }

    public File downloadPersistentMaterial(String media_id, String filePath) {
        return HttpUtil.doGet(DOWNLOAD_PERSISTENT_MATERIAL + media_id, filePath);
    }

    public File downloadPersistentMaterial(String media_id, String fileDirPath, String suffix) {
        if (!(fileDirPath = fileDirPath.replace("\\", "/")).endsWith("/")) {
            fileDirPath = fileDirPath + "/";
        }
        if (suffix.startsWith(".")) {
            suffix = suffix.substring(1);
        }
        String filePath = fileDirPath + System.currentTimeMillis() + "." + suffix;
        return HttpUtil.doGet(DOWNLOAD_PERSISTENT_MATERIAL + media_id, filePath);
    }

    public String countPersistentMaterial() {
        String ret = HttpUtil.doGet(COUNT_PERSISTENT_MATERIAL);
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("count persistent material fail : " + ret));
            return null;
        }
        return ret;
    }

    public Map<String, List<MaterialArticle>> getListNewsPersistentMaterial(Integer offset, Integer count) {
        JSONObject data = new JSONObject();
        data.put("type", (Object)"news");
        data.put("offset", (Object)offset);
        data.put("count", (Object)count);
        String ret = HttpUtil.doPost(LIST_PERSISTENT_MATERIAL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get list persistent material fail" + ret));
            return null;
        }
        HashMap<String, List<MaterialArticle>> retMap = new HashMap<String, List<MaterialArticle>>();
        JSONArray articlesJsonArray = JSONObject.parseObject((String)ret).getJSONArray("item");
        for (int i = 0; i < articlesJsonArray.size(); ++i) {
            JSONObject item = articlesJsonArray.getJSONObject(i);
            retMap.put(item.getString("media_id"), item.getJSONObject("content").getJSONArray("news_item").toJavaList(MaterialArticle.class));
        }
        return retMap;
    }

    public List<Material> getListPersistentMaterial(MaterialType type, Integer offset, Integer count) {
        JSONObject data = new JSONObject();
        data.put("type", (Object)type.toString().toLowerCase());
        data.put("offset", (Object)offset);
        data.put("count", (Object)count);
        String ret = HttpUtil.doPost(LIST_PERSISTENT_MATERIAL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("get list persistent material fail" + ret));
            return null;
        }
        return JSONObject.parseObject((String)ret).getJSONArray("item").toJavaList(Material.class);
    }

    public boolean updateNewsPersistentMaterial(String media_id, Integer index, MaterialArticle article) {
        JSONObject data = new JSONObject();
        data.put("media_id", (Object)media_id);
        data.put("index", (Object)index);
        data.put("articles", (Object)JSONObject.toJSONString((Object)article));
        String ret = HttpUtil.doPost(UPDATE_PERSISTENT_NEWS_MATERIAL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("update news persistent material fail :" + ret));
            return false;
        }
        return true;
    }

    public boolean deletePersistentMaterial(String media_id) {
        JSONObject data = new JSONObject();
        data.put("media_id", (Object)data);
        String ret = HttpUtil.doPost(DELETE_PERSISTENT_MATERIAL, data.toJSONString());
        if (JsonUtil.isError(ret)) {
            logger.info((Object)("delete persistent material fail:" + ret));
            return false;
        }
        return true;
    }

    public static MaterialComponent getInstance() {
        if (null == materialComponent) {
            materialComponent = new MaterialComponent();
        }
        return materialComponent;
    }

    static {
        UPLOAD_TEMP_MATERIAL = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=" + AccessToken.getAccessToken() + "&type=";
        UPLOAD_PERSISTENT_NEWS = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=" + AccessToken.getAccessToken();
        UPLOAD_IMG_URL = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=" + AccessToken.getAccessToken();
        UPLOAD_PERSISTENT_MATERIAL = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" + AccessToken.getAccessToken() + "&type=";
        DOWNLOAD_TEMP_MATERIAL = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=" + AccessToken.getAccessToken() + "&media_id=";
        DOWNLOAD_PERSISTENT_MATERIAL = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + AccessToken.getAccessToken();
        COUNT_PERSISTENT_MATERIAL = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=" + AccessToken.getAccessToken();
        LIST_PERSISTENT_MATERIAL = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=" + AccessToken.getAccessToken();
        UPDATE_PERSISTENT_NEWS_MATERIAL = "https://api.weixin.qq.com/cgi-bin/material/update_news?access_token=" + AccessToken.getAccessToken();
        DELETE_PERSISTENT_MATERIAL = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=" + AccessToken.getAccessToken();
    }
}

