/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.util;

import cn.zkdcloud.util.Const;
import cn.zkdcloud.util.JsonUtil;
import cn.zkdcloud.util.StreamUtil;
import cn.zkdcloud.util.WeChatUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.log4j.Logger;

public class AccessToken {
    private static Logger logger = Logger.getLogger(AccessToken.class);
    private static HttpClient httpClient = HttpClients.createDefault();
    public static String GET_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + WeChatUtil.getAppId() + "&secret=" + WeChatUtil.getAppSecret();
    private static String accessToken;
    private static long expiresIn;
    private static long lastGetTime;

    public static String getAccessToken() {
        if (null == accessToken || lastGetTime + expiresIn < System.currentTimeMillis() / 1000L) {
            return AccessToken.refresh();
        }
        return accessToken;
    }

    public static String refresh() {
        HttpGet httpGet = new HttpGet(GET_ACCESS_TOKEN_URL);
        HttpResponse response = null;
        JSONObject ret = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            ret = JSON.parseObject((String)StreamUtil.inputStreamToStr(response.getEntity().getContent()));
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)"get accessToken net error");
        }
        if (JsonUtil.isError(ret)) {
            return Const.HTTP_ERROR;
        }
        lastGetTime = System.currentTimeMillis() / 1000L;
        expiresIn = ret.getLong("expires_in");
        accessToken = ret.getString("access_token");
        logger.info((Object)"get access_token success");
        return accessToken;
    }
}

