/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.core;

import cn.zkdcloud.core.Component;
import cn.zkdcloud.core.MenuComponent;
import cn.zkdcloud.core.MessageComponent;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WeChat {
    private static Logger logger = Logger.getLogger(WeChat.class);
    private static WeChat weChat;
    private static List<Component> components;

    private WeChat() {
    }

    public void start() {
        try {
            for (Component component : this.getComponents()) {
                component.init();
            }
            logger.info((Object)"init weChat success");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("init weChat fail:" + e.getMessage()));
        }
    }

    public void startDefault() {
        this.addComponent(MessageComponent.class).addComponent(MenuComponent.class);
        this.start();
    }

    public WeChat addComponent(Class<? extends Component> componentClass) {
        try {
            this.getComponents().add(componentClass.newInstance());
            logger.info((Object)("add component : " + componentClass));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return this;
    }

    public List<Component> getComponents() {
        if (components == null) {
            components = new ArrayList<Component>();
        }
        return components;
    }

    public static WeChat create() {
        if (null == weChat) {
            weChat = new WeChat();
        }
        return weChat;
    }
}

