/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.component.menu;

import cn.zkdcloud.component.menu.AbstractButton;
import cn.zkdcloud.component.menu.MenuType;
import cn.zkdcloud.component.menu.button.MaterialButton;
import cn.zkdcloud.component.menu.button.MiniProgramButton;
import cn.zkdcloud.component.menu.button.NormalButton;
import cn.zkdcloud.component.menu.button.ViewButton;
import cn.zkdcloud.core.MenuComponent;
import cn.zkdcloud.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;

public class Menu {
    private List<AbstractButton> button = new ArrayList<AbstractButton>();

    public Menu addButton(AbstractButton button) {
        this.getButton().add(button);
        return this;
    }

    public JSONObject build() {
        String data = JSON.toJSONString((Object)this).toLowerCase();
        System.out.println(data);
        String ret = HttpUtil.doPost(MenuComponent.CREATE, data);
        if (null != ret) {
            return JSONObject.parseObject((String)ret);
        }
        return null;
    }

    public static Menu buildMenu(JSONObject menuJson) {
        Menu menu = new Menu();
        menu.setButton(Menu.buildSubMenu(menuJson.getJSONArray("button")));
        return menu;
    }

    public static List<AbstractButton> buildSubMenu(JSONArray subButtonArray) {
        if (null == subButtonArray || subButtonArray.size() == 0) {
            return null;
        }
        ArrayList<AbstractButton> ret = new ArrayList<AbstractButton>();
        for (int i = 0; i < subButtonArray.size(); ++i) {
            AbstractButton button;
            JSONObject subButton = subButtonArray.getJSONObject(i);
            if (null == subButton.getString("type")) {
                button = NormalButton.creaetOne(subButton.getString("name"));
                button.setSub_button(Menu.buildSubMenu(subButton.getJSONArray("sub_button")));
                ret.add(button);
                continue;
            }
            button = Menu.parseButton(subButton);
            ret.add(button);
        }
        return ret;
    }

    public static AbstractButton parseButton(JSONObject jsonButton) {
        AbstractButton button;
        jsonButton.put("type", (Object)jsonButton.getString("type").toUpperCase());
        switch (MenuType.valueOf(jsonButton.getString("type"))) {
            case VIEW: {
                button = (AbstractButton)jsonButton.toJavaObject(ViewButton.class);
                break;
            }
            case MINIPROGRAM: {
                button = (AbstractButton)jsonButton.toJavaObject(MiniProgramButton.class);
                break;
            }
            case MEDIA_ID: {
                button = (AbstractButton)jsonButton.toJavaObject(MaterialButton.class);
                break;
            }
            case VIEW_LIMITED: {
                button = (AbstractButton)jsonButton.toJavaObject(MaterialButton.class);
                break;
            }
            default: {
                button = (AbstractButton)jsonButton.toJavaObject(NormalButton.class);
            }
        }
        return button;
    }

    public List<AbstractButton> getButton() {
        return this.button;
    }

    public void setButton(List<AbstractButton> button) {
        this.button = button;
    }
}

