/*
 * Decompiled with CFR 0.152.
 */
package cn.zkdcloud.upload;

import cn.zkdcloud.upload.ConstUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;

public class UploadServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(UploadServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.preHandler(req, resp);
        Part part = req.getPart(ConstUtil.getNameProperty());
        String originFileName = part.getSubmittedFileName();
        String ret = this.checkFile(part);
        if (ret != null) {
            part.write(ret + "/" + originFileName);
            resp.getWriter().print(ConstUtil.getHostUrl() + "/resources/" + ret + "/" + originFileName);
            logger.info((Object)("ip\u4e3a" + this.getIp(req) + "\u5b58\u5165\u7684\u6587\u4ef6\u662f\uff1a" + originFileName));
        } else {
            resp.getWriter().print("\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301");
            logger.error((Object)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u652f\u6301");
        }
    }

    private void preHandler(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        request.setCharacterEncoding("utf-8");
        response.setContentType("text/html;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
    }

    private String checkFile(Part part) {
        String submittedFileName = part.getSubmittedFileName();
        String suffix = submittedFileName.substring(submittedFileName.lastIndexOf(46) + 1, submittedFileName.length());
        for (String filter : ConstUtil.getSuffixFilter().split(",")) {
            if (!suffix.equals(filter)) continue;
            this.initSubDir(suffix);
            return suffix;
        }
        return null;
    }

    private String getIp(HttpServletRequest request) {
        if (request.getHeader("x-forwarded-for") == null) {
            return request.getRemoteAddr();
        }
        return request.getHeader("x-forwarded-for");
    }

    private void initSubDir(String dirName) {
        String subDirPath = ConstUtil.getLocation() + "/" + dirName;
        File subDir = new File(subDirPath);
        if (!subDir.exists()) {
            subDir.mkdir();
            logger.info((Object)("\u521d\u59cb\u5316\u5b50\u76ee\u5f55\uff1a" + dirName));
        }
    }
}

