package com.sprite.utils.text;

/**
 * 不区分大小写
 *
 * @author Jack
 * @since 1.2.4
 */
public class InsensitiveString implements CharSequence{

    public static InsensitiveString insensitive(String value) {
        return new InsensitiveString(value);
    }

    private String originalStr;
    private String lowStr;

    private InsensitiveString(CharSequence str) {
        originalStr = str.toString();
        lowStr = originalStr.toLowerCase();
    }

    /**
     * 获取原始值
     * @return 原始字符
     */
    public String getOriginal() {
        return originalStr;
    }


    @Override
    public int hashCode() {
        return lowStr.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CharSequence) {
           return lowStr.equalsIgnoreCase(obj.toString());
        }

        return super.equals(obj);
    }

    @Override
    public int length() {
        return originalStr.length();
    }

    @Override
    public char charAt(int index) {
        return originalStr.charAt(index);
    }
    @Override
    public CharSequence subSequence(int start, int end) {
        return originalStr.subSequence(start, end);
    }

    @Override
    public String toString() {
        return originalStr;
    }
}
