package com.sprite.utils.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Message digest
 *
 * @author Jackl
 */
public class UtilMessageDigest {

    private static final char[] HEX_CHARS = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String md5(String str) {
        return md5(str, null);
    }


    /**
     * @param context
     *         The byte array to md5
     * @return md5 result
     */
    public static final String md5(byte[] context) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(context);
        } catch (NoSuchAlgorithmException e) {
        }

        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        int bs;
        for (byte bt : byteArray) {
            bs = bt;
            if (bs < 0) {
                bs += 256;
            }
            md5StrBuff.append(HEX_CHARS[bs >> 4]);
            md5StrBuff.append(HEX_CHARS[bs & 0x0F]);
        }
        return md5StrBuff.toString();
    }

    /**
     * MD5摘要计算
     *
     * @param str
     *         文本
     * @param charSet
     *         文本字符集
     * @return 摘要文本
     */
    public static final String md5(String str, String charSet) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            if (charSet == null) {
                messageDigest.update(str.getBytes());
            } else {
                messageDigest.update(str.getBytes(charSet));
            }
        } catch (NoSuchAlgorithmException e) {
        } catch (UnsupportedEncodingException e) {
        }

        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        int bs;
        for (byte bt : byteArray) {
            bs = bt;
            if (bs < 0) {
                bs += 256;
            }
            md5StrBuff.append(HEX_CHARS[bs >> 4]);
            md5StrBuff.append(HEX_CHARS[bs & 0x0F]);
        }
        return md5StrBuff.toString();
    }

    public static final String sha1(String str) {
        return sha1(str, null);
    }

    /**
     * SHA1
     *
     * @param str
     *         文本
     * @param charSet
     *         文本字符集
     * @return 散列值
     */
    public static final String sha1(String str, String charSet) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.reset();
            if (charSet == null) {
                messageDigest.update(str.getBytes());
            } else {
                messageDigest.update(str.getBytes(charSet));
            }
        } catch (NoSuchAlgorithmException e) {
        } catch (UnsupportedEncodingException e) {
        }

        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        int bs;
        for (byte bt : byteArray) {
            bs = bt;
            if (bs < 0) {
                bs += 256;
            }
            md5StrBuff.append(HEX_CHARS[bs >> 4]);
            md5StrBuff.append(HEX_CHARS[bs & 0x0F]);
        }
        return md5StrBuff.toString();
    }

    /**
     * SHA1
     *
     * @param content
     *         The byte array to be sha1
     * @return sha1 result
     * @since 1.2.3
     */
    public static String sha1(byte[] content) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.reset();
            messageDigest.update(content);
        } catch (NoSuchAlgorithmException e) {
        }

        byte[] byteArray = messageDigest.digest();
        StringBuffer md5StrBuff = new StringBuffer();
        int bs;
        for (byte bt : byteArray) {
            bs = bt;
            if (bs < 0) {
                bs += 256;
            }
            md5StrBuff.append(HEX_CHARS[bs >> 4]);
            md5StrBuff.append(HEX_CHARS[bs & 0x0F]);
        }
        return md5StrBuff.toString();
    }
}
