package com.sprite.utils.mimetype;

import java.net.URL;
import java.util.Properties;

/**
 * @author Jack
 * @since 1.2.4
 */
public class UtilMimeType {
    // key is file suffix
    private static final Properties fileMimes = new Properties();

    static {
        try {
            URL url = UtilMimeType.class.getResource("filemimes.properties");
            fileMimes.load(url.openStream());
        } catch (Exception e) {
        }
    }

    /**
     * 获取指定文件后缀的mime type
     *
     * @param fileSuffix
     *         文件后缀
     * @return mime type
     */
    public static String mimeTypeByFileSuffix(String fileSuffix) {
        if (fileSuffix == null) {
            return null;
        }
        return fileMimes.getProperty(fileSuffix.toLowerCase());
    }

    /**
     * 获取指定文件后缀的mime type
     *
     * @param fileSuffix
     *         文件后缀
     * @param defaultMimeType
     *         默认值
     * @return mime type
     */
    public static String mimeTypeByFileSuffix(String fileSuffix, String defaultMimeType) {
        if (fileSuffix == null) {
            return defaultMimeType;
        }
        return fileMimes.getProperty(fileSuffix.toLowerCase(), defaultMimeType);
    }

    public static void main(String[] args) {
        System.out.println(mimeTypeByFileSuffix("txt"));
    }
}
