package com.sprite.utils.http.payload;

import com.sprite.utils.UtilString;
import com.sprite.utils.http.ContentDisposition;
import com.sprite.utils.http.ContentType;
import com.sprite.utils.http.RequestPayload;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

/**
 * @author Jack
 * @since 1.2.4
 */
public class MultipartData implements RequestPayload {
    private ContentType contentType = new ContentType("multipart/form-data; boundary=---------------------------" + UUID.randomUUID().toString().replace("-", ""));


    public LinkedHashMap<String, Object> parameter = new LinkedHashMap<>();

    @Override
    public void writePayload(OutputStream outputStream) throws IOException {
        String boundary = "--" + contentType.getParam("boundary");

        ContentDisposition contentDisposition;
        ContentType contentType = null;
        StringBuilder stam = new StringBuilder();
        for (Map.Entry<String, Object> param : parameter.entrySet()) {
            stam.setLength(0);

            outputStream.write(boundary.getBytes());
            outputStream.write("\n".getBytes());

            Object value = param.getValue();
            RequestPayload payload;
            if (value instanceof MultipartData) {
                MultipartData multipartData = (MultipartData) value;
                payload = multipartData;
                contentType = multipartData.getContentType();
                multipartData.writePayload(outputStream);
                contentDisposition = new ContentDisposition("form-data; ");
                contentDisposition.putParam("name", param.getKey());
            } else {
                SimpleData simpleData = new SimpleData();
                payload = simpleData;
                simpleData.setData(value);
                contentType = simpleData.getContentType();
                contentDisposition = simpleData.getContentDisposition();
                if (contentDisposition == null) {
                    contentDisposition = new ContentDisposition("form-data; ");
                }
                contentDisposition.putParam("name", param.getKey());
                contentDisposition.setMediaType("form-data");
            }

            stam.append("Content-Disposition: ").append(contentDisposition.toString()).append("\n");

            if (contentType != null) {
                stam.append("Content-Type: ").append(contentType.toString()).append("\n");
            }
            stam.append("\n");
            outputStream.write(stam.toString().getBytes());

            payload.writePayload(outputStream);
            outputStream.write("\n".getBytes());
        }
        outputStream.write(UtilString.place("{0}--", boundary).getBytes());
    }

    /**
     * 添加表单参数
     *
     * @param key
     *         param name
     * @param value
     *         param value
     */
    public void putParam(String key, Object value) {
        if (value == null) {
            return;
        }
        parameter.put(key, value);
    }

    /**
     * 获取表单参数
     *
     * @param key
     *         param name
     * @return param value
     */
    public Object getParam(String key) {
        return parameter.get(key);
    }


    /**
     * 获取 content type
     *
     * @return
     * @since 1.2.4
     */
    @Override
    public ContentType getContentType() {
        return contentType;
    }

    public void setCharset(String charset) {
        contentType.putParam("charset", charset);
    }

    public String getCharset() {
        return contentType.getCharset();
    }

}
