package com.sprite.utils.http;

/**
 * 描述一个http或https 请求
 *
 * @author Jack
 * @since 1.2.4
 */
public class HttpRequest {

    private String url;
    private UrlParams urlParams;
    private Headers headers;
    private RequestPayload requestPayload;

    public HttpResponse get() throws Exception {
        return UtilHttp.request(url, HttpConstant.Method.GET, headers, urlParams, requestPayload);
    }

    public HttpResponse put() throws Exception {
        return UtilHttp.request(url, HttpConstant.Method.PUT, headers, urlParams, requestPayload);
    }

    public HttpResponse post() throws Exception {
        return UtilHttp.request(url, HttpConstant.Method.POST, headers, urlParams, requestPayload);
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public UrlParams getUrlParams() {
        return urlParams;
    }

    public void setUrlParams(UrlParams urlParams) {
        this.urlParams = urlParams;
    }

    public Headers getHeaders() {
        return headers;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public RequestPayload getRequestPayload() {
        return requestPayload;
    }

    public void setRequestPayload(RequestPayload requestPayload) {
        this.requestPayload = requestPayload;
    }
}
