package com.sprite.utils.http;

/**
 * @author Jack
 */
public class HttpException extends Exception{

	/**
	 * 
	 */
	private static final long serialVersionUID = -7030726909545091521L;
	private int statusCode;
	private String responseMessage;
	private String reponseText;

	
	public HttpException(int statusCode, String message, String reponseText) {
		super("Http Request is not success, Response code is "+statusCode);
		this.statusCode = statusCode;
		this.responseMessage = message;
		this.reponseText = reponseText;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public String getResponseMessage() {
		return responseMessage;
	}

	public String getReponseText() {
		return reponseText;
	}
	
}
