package com.sprite.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;

public class DefaultHttpResponse implements HttpResponse{

    private HttpURLConnection httpURLConnection;

    public DefaultHttpResponse(HttpURLConnection httpURLConnection){
        this.httpURLConnection = httpURLConnection;
    }


    @Override
    public int getStatusCode() throws IOException {
        return httpURLConnection.getResponseCode();
    }

    @Override
    public String getStatusMessage() throws IOException {
        return httpURLConnection.getResponseMessage();
    }

    @Override
    public String getHeader(String header) throws IOException {
        return httpURLConnection.getHeaderField(header);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if(httpURLConnection.getResponseCode() == HttpURLConnection.HTTP_OK){
            return httpURLConnection.getInputStream();
        }
        return httpURLConnection.getErrorStream();
    }
}
