package com.sprite.utils.http;

import com.sprite.utils.mimetype.MimeType;

import java.util.UUID;

/**
 * Content type
 * <a href="https://tools.ietf.org/html/rfc7231#section-3.1.1.1">标准</a>
 * @author Jack
 */
public class ContentType {

    private MimeType mimeType;

    public ContentType() {
        mimeType = new MimeType();
    }

    public ContentType(String content) {
        mimeType = new MimeType(content);
    }

    public String getMediaType() {
        return mimeType.getMimeType();
    }

    public void setMediaType(String mediaType) {
        mimeType.setMimeType(mediaType);
    }

    public String getCharset() {
        return getParam("charset");
    }

    public void setCharset(String charset) {
        putParam("charset", charset);
    }

    public String getBoundary() {
        return getParam("boundary");
    }

    public void setBoundary(String boundary) {
        putParam("boundary", boundary);
    }

    public void putParam(String key, Object value){
        mimeType.putParam(key, value);
    }

    public String getParam(String key){
        return mimeType.getParam(key);
    }

    public String toContentTypeString() {
        return mimeType.toString();
    }

    public static ContentType resolve(String content) {
        return new ContentType(content);
    }

    @Override
    public String toString() {
        return toContentTypeString();
    }

    public static void main(String[] args) {
       // ContentType contentType = new ContentType("multipart/form-data; boundary=something");
//        System.out.println(contentType);
//        contentType = new ContentType("multipart/form-data; ");
//        System.out.println(contentType);
        ContentType contentType =  new ContentType("multipart/form-data; boundary=---------------------------" + UUID.randomUUID().toString().replace("-", ""));
        contentType.putParam("start", "test a");
        System.out.println(contentType.getParam("start"));
        System.out.println(contentType.getParam("boundary"));
    }
}
