package com.sprite.utils.http;

import com.sprite.utils.mimetype.MimeType;

/**
 * @author Jack
 * @since 1.2.4
 */
public class ContentDisposition{
    private MimeType mimeType;

    public ContentDisposition(){
        mimeType = new MimeType();
    }
    public ContentDisposition(String content) {
        mimeType = new MimeType(content);
    }

    public String getMediaType() {
        return mimeType.getMimeType();
    }

    public void setMediaType(String mediaType) {
        mimeType.setMimeType(mediaType);
    }

    public String getCharset() {
        return getParam("charset");
    }

    public void setCharset(String charset) {
        putParam("charset", charset);
    }

    public String getBoundary() {
        return getParam("boundary");
    }

    public void setBoundary(String boundary) {
        putParam("boundary", boundary);
    }

    public void putParam(String key, Object value){
        mimeType.putParam(key, value);
    }

    public String getParam(String key){
        return mimeType.getParam(key);
    }

    public String toString() {
        return mimeType.toString();
    }

}
