package com.sprite.utils.conversion;

/**
 * 默认的 String 转换器
 *
 * @author Jack
 * @since 1.2.6
 */
public class StringConverter implements Converter<Object, String> {

    @Override
    public String convert(Object source) throws ConversionException {
        if (source == null) {
            return null;
        }
        return String.valueOf(source);
    }

    @Override
    public Class<Object> getSourceClass() {
        return Object.class;
    }

    @Override
    public Class<String> getTargetClass() {
        return String.class;
    }
}
