package com.sprite.utils.conversion;

import java.math.BigInteger;

/**
 * 其他类型转为 Long
 *
 * @author Jack
 * @since 1.0.0
 */
public class LongConverters implements ConverterLoader {
    public static class LongToString implements Converter<Long, String> {

        @Override
        public String convert(Long obj) throws ConversionException {
            if (obj == null) {
                return null;

            }
            return obj.toString();
        }

        @Override
        public Class<Long> getSourceClass() {
            return Long.class;
        }

        @Override
        public Class<String> getTargetClass() {
            return String.class;
        }
    }

    public static class StringToLong implements Converter<String, Long> {

        @Override
        public Long convert(String obj) throws ConversionException {
            return Long.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    }

    public static class StringToBaseLong implements Converter<String, Long> {

        @Override
        public Long convert(String obj) throws ConversionException {
            if(obj == null){
                return 0L;
            }
            return Long.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return long.class;
        }
    }

    public static class LongToBaseLong implements Converter<Long, Long> {

        @Override
        public Long convert(Long obj) throws ConversionException {
            if(obj == null){
                return 0L;
            }
            return obj.longValue();
        }

        @Override
        public Class<Long> getSourceClass() {
            return Long.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return long.class;
        }
    }

    public static class BigIntegerToBaseLong implements Converter<BigInteger, Long> {

        @Override
        public Long convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return 0L;
            }
            return obj.longValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return long.class;
        }
    }

    public static class BigIntegerToLong implements Converter<BigInteger, Long> {

        @Override
        public Long convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.longValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    }

    /**
     * integer 转 Long
     *
     * @since 1.2.5
     */
    public static class IntegerToLong implements Converter<Integer, Long> {

        @Override
        public Long convert(Integer source) throws ConversionException {
            if (source == null) {
                return null;
            }
            return source.longValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    }

    /**
     * integer 转 long
     *
     * @since 1.2.5
     */
    public static class IntegerToBaseLong implements Converter<Integer, Long> {

        @Override
        public Long convert(Integer source) throws ConversionException {
            if (source == null) {
                return 0L;
            }
            return source.longValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return long.class;
        }
    }

    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(LongConverters.class);
    }

}
