package com.sprite.utils.conversion;

/**
 * 其他类型转为 Integer
 *
 * @author Jack
 * @since 1.0.0
 */
public class IntegerConverters implements ConverterLoader {
    public static class StringToInteger implements Converter<String, Integer> {

        @Override
        public Integer convert(String obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return Integer.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return Integer.class;
        }
    }

    public static class StringToInt implements Converter<String, Integer> {

        @Override
        public Integer convert(String obj) throws ConversionException {
            if (obj == null) {
                return 0;
            }
            return Integer.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return int.class;
        }
    }

    public static class IntegerToInt implements Converter<Integer, Integer> {

        @Override
        public Integer convert(Integer obj) throws ConversionException {
            if (obj == null) {
                return 0;
            }
            return obj.intValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return int.class;
        }
    }

    /**
     * @since 1.2.7
     */
    public static class LongToInt implements Converter<Long, Integer> {

        @Override
        public Integer convert(Long obj) throws ConversionException {
            if (obj == null) {
                return 0;
            }
            return obj.intValue();
        }

        @Override
        public Class<Long> getSourceClass() {
            return Long.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return int.class;
        }
    }

    /**
     * @since 1.2.7
     */
    public static class LongToInteger implements Converter<Long, Integer> {

        @Override
        public Integer convert(Long obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.intValue();
        }

        @Override
        public Class<Long> getSourceClass() {
            return Long.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return Integer.class;
        }
    }

    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(IntegerConverters.class);
    }

}
