package com.sprite.utils.conversion;

import java.math.BigInteger;

/**
 * 其他类型转为 Double
 *
 * @author Jack
 * @since 1.2.4
 */
public class DoubleConverters implements ConverterLoader {

    public static class BigIntegerToDouble implements Converter<BigInteger, Double> {

        @Override
        public Double convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.class;
        }
    }

    public static class BigIntegerToBaseDouble implements Converter<BigInteger, Double> {

        @Override
        public Double convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return 0D;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return double.class;
        }
    }

    public static class IntegerToDouble implements Converter<Integer, Double> {

        @Override
        public Double convert(Integer obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.class;
        }
    }

    public static class IntegerToBaseDouble implements Converter<Integer, Double> {

        @Override
        public Double convert(Integer obj) throws ConversionException {
            if (obj == null) {
                return 0D;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return double.class;
        }
    }


    public static class StringToDouble implements Converter<String, Double> {

        @Override
        public Double convert(String obj) throws ConversionException {
            return Double.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.class;
        }
    }

    public static class StringToBaseDouble implements Converter<String, Double> {

        @Override
        public Double convert(String obj) throws ConversionException {
            if(obj == null){
                return 0D;
            }
            return Double.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return double.class;
        }
    }

    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(DoubleConverters.class);
    }
}
