package com.sprite.utils.conversion;

/**
 * 其他类型转为 Boolean
 * @author Jack
 * @since 1.0.0
 */
public class BooleanConverters implements ConverterLoader {
    public static class StringToBoolean implements Converter<String, Boolean> {

        @Override
        public Boolean convert(String source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }

            source = source.trim();

            return Boolean.valueOf(source);

        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return Boolean.class;
        }

    }

    public static class StringToBaseBoolean implements Converter<String, Boolean> {

        @Override
        public Boolean convert(String source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }

            source = source.trim();

            return Boolean.valueOf(source);

        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return boolean.class;
        }

    }

    public static class BooleanToBaseBoolean implements Converter<Boolean, Boolean> {

        @Override
        public Boolean convert(Boolean source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }

            return Boolean.valueOf(source);
        }

        @Override
        public Class<Boolean> getSourceClass() {
            return Boolean.class;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return boolean.class;
        }

    }


    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(BooleanConverters.class);
    }
}
