package com.sprite.utils.cache;

import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;


/**
 * <p>内存缓存，一种软缓存，内存吃紧时，会自动释放内存</p>
 * 线程安全的
 *
 * @author Jack
 */
public final class UtilSoftCache<V> implements Cache<V> {

    private ConcurrentHashMap<String, SoftReference<V>> utilCacheTable = new ConcurrentHashMap<String, SoftReference<V>>();

    private String name;

    private UtilSoftCache(String name) {
        this.name = name;
    }

    @Override
    public void put(String key, V value) {
        utilCacheTable.put(key, new SoftReference<V>(value));
    }

    @Override
    public V get(String key) {
        if (key == null) {
            return null;
        }
        SoftReference<V> soft = utilCacheTable.get(key);
        if (soft != null) {
            return soft.get();
        }
        return null;
    }

    public static <V> UtilSoftCache<V> createUtilCache(String cacheName) {
        return new UtilSoftCache<V>(cacheName);
    }

    @Override
    public V putIfAbsent(String cacheKey, V v) {
        SoftReference<V> soft = new SoftReference<V>(v);
        soft = utilCacheTable.putIfAbsent(cacheKey, soft);
        if (soft != null) {
            return soft.get();
        }
        return v;
    }

    @Override
    public V remove(String cacheKey) {
        SoftReference<V> soft = utilCacheTable.remove(cacheKey);
        if (soft != null)
            return soft.get();
        return null;
    }

    @Override
    public String getCacheName() {
        return name;
    }

}
