package com.sprite.utils.cache;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;


/**
 * <p>内存缓存</p>
 * 线程安全的
 *
 * @author Jack
 */
public final class UtilCache<V> implements Cache<V> {

    public static <V> UtilCache<V> createUtilCache(String cacheName) {
        return new UtilCache<V>(cacheName);
    }

    private ConcurrentHashMap<String, V> utilCacheTable = new ConcurrentHashMap<String, V>();
    private String name;

    private UtilCache(String name) {
        this.name = name;
    }

    @Override
    public String getCacheName() {
        return name;
    }

    @Override
    public void put(String key, V value) {
        utilCacheTable.put(key, value);
    }

    @Override
    public V get(String key) {
        return utilCacheTable.get(key);
    }

    @Override
    public V putIfAbsent(String cacheKey, V v) {
        return utilCacheTable.putIfAbsent(cacheKey, v);
    }

    @Override
    public V remove(String cacheKey) {
        return utilCacheTable.remove(cacheKey);
    }

    public List<V> values() {
        return new LinkedList<>(utilCacheTable.values());
    }
}
