package com.sprite.utils;

import java.util.Collection;
import java.util.Iterator;

/**
 * @author Jack
 *
 */
public final class UtilCollection {
	public static boolean isEmpty(Collection<?> collection){
		return !isNotEmpty(collection);
	}
	
	public static boolean isNotEmpty(Collection<?> collection){
		return collection != null && collection.size() > 0;
	}
	
	public static  <T> T first(Collection<T> collection){
		return at(collection, 0);
	}
	
	public static  <T> T at(Collection<T> collection, int i){
		return at(collection, i, null);
	}
	
	public static  <T> T at(Collection<T> collection, int i, T defaultValue){
		if(collection ==null)return null;
		
		if(i<0){
			i=i+collection.size();
		}

		Iterator<T> iterator = collection.iterator();
		
		while(iterator.hasNext()){
			T t = iterator.next();
			if(i==0){
				return t;
			}else{
				i--;
			}
		}
		return defaultValue;
	}

	public static <T> int size(Collection<T> collection){
		if(collection == null){
			return 0;
		}

		return collection.size();
	}
	private UtilCollection(){}
}
