package com.sprite.utils;

/**
 * @author Jack
 *
 */
public final class UtilArray {

	@SafeVarargs
	public static <T> T[] toArray(T... arr){
		return arr;
	}
	
	public static  <T> T at(T[] ts, int i, T defaultValue){
		if(i<0){
			i=i+ts.length;
		}
		if(ts == null || ts.length <= i){
			return defaultValue;
		}else{
			return ts[i];
		}
	}
	
	public static <T> boolean contained(T[] ts, T t){
		if(ts == null || t == null){
			return false;
		}
		for(T o : ts){
			if(o != null && o.equals(t)){
				return true;
			}
		}
		
		return false;
	}
	
	public static <T> boolean isEmpty(T[] ts){
		return ts == null | ts.length ==0;
	}
	
	private UtilArray(){}
}
