/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.json;

import com.sprite.utils.json.JsonString;
import java.util.HashMap;
import java.util.Map;

public class JsonObject {
    private String prefix = "{";
    private String suffix = "}";
    private Map<String, Object> filedMap = new HashMap<String, Object>();

    public void put(String key, Object value) {
        this.filedMap.put(key, value);
    }

    public <T> T get(String key) {
        return (T)this.filedMap.get(key);
    }

    public void putJsonString(String key, String json) {
        this.filedMap.put(key, new JsonString(json));
    }

    public String toJson() {
        StringBuilder json = new StringBuilder();
        json.append(this.prefix);
        boolean isFirst = true;
        for (Map.Entry<String, Object> entry : this.filedMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (!isFirst) {
                json.append(",");
            }
            json.append("\"").append(entry.getKey()).append("\":");
            if (JsonObject.class.isInstance(value)) {
                json.append(value.toString());
            } else if (CharSequence.class.isInstance(value)) {
                json.append("\"").append(value).append("\"");
            } else if (Number.class.isInstance(value)) {
                json.append(value.toString());
            } else {
                json.append(value);
            }
            isFirst = false;
        }
        json.append(this.suffix);
        return json.toString();
    }
}

