/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http.payload;

import com.sprite.utils.UtilString;
import com.sprite.utils.http.ContentDisposition;
import com.sprite.utils.http.ContentType;
import com.sprite.utils.http.RequestPayload;
import com.sprite.utils.io.UtilIO;
import com.sprite.utils.mimetype.UtilMimeType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class SimpleData
implements RequestPayload {
    private ContentType contentType;
    private ContentDisposition contentDisposition;
    private Object data;

    @Override
    public void writePayload(OutputStream outputStream) throws IOException {
        if (this.data instanceof File) {
            UtilIO.write(new FileInputStream((File)this.data), outputStream);
        } else if (this.data instanceof byte[]) {
            outputStream.write((byte[])this.data);
        } else {
            String charset;
            String string = charset = this.contentType != null ? this.contentType.getCharset() : null;
            if (charset == null) {
                charset = Charset.defaultCharset().name();
            }
            outputStream.write(String.valueOf(this.data).getBytes(charset));
        }
    }

    public void setData(Object data) {
        this.setData(data, null);
    }

    public void setData(Object data, String contentType) {
        if (UtilString.isNotBlank(contentType)) {
            this.contentType = new ContentType(contentType);
        }
        this.data = data;
        if (data instanceof File) {
            File file = (File)data;
            this.contentDisposition = new ContentDisposition();
            String filename = file.getName();
            this.contentDisposition.putParam("filename", file.getName());
            String mimeType = UtilMimeType.mimeTypeByFileSuffix(this.filesuffix(filename));
            if (this.contentType == null && UtilString.isNotBlank(mimeType)) {
                this.contentType = new ContentType(mimeType);
            } else if (UtilString.isBlank(this.contentType.getMediaType()) && UtilString.isNotBlank(mimeType)) {
                this.contentType.setMediaType(mimeType);
            }
        }
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public ContentDisposition getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public Object getData() {
        return this.data;
    }

    private String filesuffix(String file) {
        int i = file.lastIndexOf(46);
        if (i >= 0) {
            return file.substring(i + 1);
        }
        return null;
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }
}

