/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http.payload;

import com.sprite.utils.UtilString;
import com.sprite.utils.http.ContentType;
import com.sprite.utils.http.RequestPayload;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;

public class FormData
implements RequestPayload {
    private ContentType contentType = new ContentType("application/x-www-form-urlencoded; charset=" + Charset.defaultCharset().name());
    public LinkedHashMap<String, Object> parameter = new LinkedHashMap();

    @Override
    public void writePayload(OutputStream outputStream) throws IOException {
        String paramCharset = this.getCharset();
        if (paramCharset != null) {
            paramCharset = Charset.defaultCharset().name();
        }
        StringBuilder finalUrl = new StringBuilder();
        for (Map.Entry<String, Object> param : this.parameter.entrySet()) {
            finalUrl.append(param.getKey()).append("=").append(URLEncoder.encode(UtilString.toString(param.getValue()), paramCharset)).append("&");
        }
        finalUrl.deleteCharAt(finalUrl.length() - 1);
        outputStream.write(finalUrl.toString().getBytes());
    }

    public void putParam(String key, Object value) {
        if (value == null) {
            return;
        }
        this.parameter.put(key, value);
    }

    public Object getParam(String key) {
        return this.parameter.get(key);
    }

    public void setCharset(String charset) {
        this.contentType.putParam("charset", charset);
    }

    public String getCharset() {
        return this.contentType.getCharset();
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }
}

