/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http;

import com.sprite.utils.UtilString;
import com.sprite.utils.http.ContentType;
import com.sprite.utils.http.DefaultHttpResponse;
import com.sprite.utils.http.Headers;
import com.sprite.utils.http.HttpException;
import com.sprite.utils.http.HttpResponse;
import com.sprite.utils.http.RequestPayload;
import com.sprite.utils.http.UrlParams;
import com.sprite.utils.io.UtilIO;
import com.sprite.utils.text.InsensitiveString;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class UtilHttp {
    private static Headers defaultHeaders = new Headers();

    private static String finalUrl(String url, UrlParams urlParam) throws UnsupportedEncodingException {
        if (urlParam == null) {
            return url;
        }
        return urlParam.appendToUrl(url);
    }

    public static HttpResponse request(String url, String method, Headers headers, UrlParams urlParams, RequestPayload requestPayload) throws Exception {
        url = UtilHttp.finalUrl(url, urlParams);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod(method);
        if (headers != null) {
            for (Map.Entry<InsensitiveString, Object> header : headers.entrySet()) {
                httpURLConnection.setRequestProperty(header.getKey().getOriginal(), UtilString.toString(header.getValue()));
            }
        }
        for (Map.Entry<InsensitiveString, Object> header : defaultHeaders.entrySet()) {
            httpURLConnection.setRequestProperty(header.getKey().getOriginal(), UtilString.toString(header.getValue()));
        }
        if (requestPayload != null) {
            httpURLConnection.setDoOutput(true);
            if (requestPayload.getContentType() != null) {
                httpURLConnection.setRequestProperty("Content-Type", requestPayload.getContentType().toContentTypeString());
            }
            requestPayload.writePayload(httpURLConnection.getOutputStream());
        }
        return new DefaultHttpResponse(httpURLConnection);
    }

    public static HttpResponse get(String url) throws Exception {
        return UtilHttp.request(url, "GET", null, null, null);
    }

    public static InputStream getToStream(String url, Headers headers, UrlParams urlParams) throws Exception {
        HttpResponse response = UtilHttp.request(url, "GET", headers, urlParams, null);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType == null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return response.getInputStream();
    }

    public static InputStream getToStream(String url) throws Exception {
        return UtilHttp.getToStream(url, null, null);
    }

    public static byte[] getToByte(String url, Headers headers, UrlParams urlParams) throws Exception {
        InputStream inputStream = UtilHttp.getToStream(url, headers, urlParams);
        return UtilIO.readToBytes(inputStream);
    }

    public static byte[] getToByte(String url) throws Exception {
        return UtilHttp.getToByte(url, null, null);
    }

    public static String getToText(String url, Headers headers, UrlParams urlParams) throws Exception {
        HttpResponse response = UtilHttp.request(url, "GET", headers, urlParams, null);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType != null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return UtilIO.readToText(response.getInputStream(), charset);
    }

    public static String getToText(String url) throws Exception {
        return UtilHttp.getToText(url, null, null);
    }

    public static InputStream postToStream(String url, Headers headers, UrlParams urlParam, RequestPayload requestPayload) throws Exception {
        HttpResponse response = UtilHttp.request(url, "POST", headers, urlParam, requestPayload);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType == null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return response.getInputStream();
    }

    public static byte[] postToByte(String url, Headers headers, UrlParams urlParams, RequestPayload requestPayload) throws Exception {
        InputStream inputStream = UtilHttp.postToStream(url, headers, urlParams, requestPayload);
        return UtilIO.readToBytes(inputStream);
    }

    public static String postToText(String url, Headers headers, UrlParams urlParams, RequestPayload requestPayload) throws Exception {
        HttpResponse response = UtilHttp.request(url, "POST", headers, urlParams, requestPayload);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType != null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return UtilIO.readToText(response.getInputStream(), charset);
    }

    public static void main(String[] args) throws Exception {
        String response = UtilHttp.getToText("https://tools.ietf.org/html/rfc7233#section-4.1");
        System.out.println(response);
    }

    static {
        defaultHeaders.addHeader("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.119 Safari/537.36 SpriteUtilHttp/1.0");
    }
}

