/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http;

import com.sprite.utils.UtilString;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class UrlParams
extends HashMap<String, Object> {
    private static final long serialVersionUID = -6016715899215393800L;
    private String charset;

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toQueryString() throws UnsupportedEncodingException {
        if (this.isEmpty()) {
            return "";
        }
        String paramCharset = this.charset != null ? this.charset : Charset.defaultCharset().name();
        StringBuilder finalUrl = new StringBuilder();
        for (Map.Entry param : this.entrySet()) {
            finalUrl.append((String)param.getKey()).append("=").append(URLEncoder.encode(UtilString.toString(param.getValue()), paramCharset)).append("&");
        }
        finalUrl.deleteCharAt(finalUrl.length() - 1);
        return finalUrl.toString();
    }

    public String appendToUrl(String url) throws UnsupportedEncodingException {
        if (this.isEmpty()) {
            return url;
        }
        StringBuilder finalUrl = new StringBuilder(url);
        String paramCharset = this.charset != null ? this.charset : Charset.defaultCharset().name();
        int i = url.lastIndexOf(63);
        if (i < 0) {
            finalUrl.append("?");
        } else if (i > 0 && !url.endsWith("&")) {
            finalUrl.append('&');
        }
        for (Map.Entry param : this.entrySet()) {
            finalUrl.append((String)param.getKey()).append("=").append(URLEncoder.encode(UtilString.toString(param.getValue()), paramCharset)).append("&");
        }
        finalUrl.deleteCharAt(finalUrl.length() - 1);
        return finalUrl.toString();
    }
}

