/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http;

import com.sprite.utils.mimetype.MimeType;
import java.util.UUID;

public class ContentType {
    private MimeType mimeType;

    public ContentType() {
        this.mimeType = new MimeType();
    }

    public ContentType(String content) {
        this.mimeType = new MimeType(content);
    }

    public String getMediaType() {
        return this.mimeType.getMimeType();
    }

    public void setMediaType(String mediaType) {
        this.mimeType.setMimeType(mediaType);
    }

    public String getCharset() {
        return this.getParam("charset");
    }

    public void setCharset(String charset) {
        this.putParam("charset", charset);
    }

    public String getBoundary() {
        return this.getParam("boundary");
    }

    public void setBoundary(String boundary) {
        this.putParam("boundary", boundary);
    }

    public void putParam(String key, Object value) {
        this.mimeType.putParam(key, value);
    }

    public String getParam(String key) {
        return this.mimeType.getParam(key);
    }

    public String toContentTypeString() {
        return this.mimeType.toString();
    }

    public static ContentType resolve(String content) {
        return new ContentType(content);
    }

    public String toString() {
        return this.toContentTypeString();
    }

    public static void main(String[] args) {
        ContentType contentType = new ContentType("multipart/form-data; boundary=---------------------------" + UUID.randomUUID().toString().replace("-", ""));
        contentType.putParam("start", "test a");
        System.out.println(contentType.getParam("start"));
        System.out.println(contentType.getParam("boundary"));
    }
}

