/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.crypto;

import com.sprite.utils.UtilString;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public final class UtilRSA {
    public static final String PADDING_NO_PADDING = "NoPadding";
    public static final String PADDING_PKCS1_PADDING = "PKCS1Padding";
    public static final String PADDING_OAEP_PADDING = "OAEPPadding";
    private static volatile KeyFactory keyFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() throws Exception {
        if (keyFactory != null) return;
        Class<UtilRSA> clazz = UtilRSA.class;
        synchronized (UtilRSA.class) {
            if (keyFactory != null) return;
            keyFactory = KeyFactory.getInstance("RSA");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static KeyPair generateKeyPair(int keySize) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    public static byte[] decryptByPrivateKey(byte[] content, byte[] key, String padding) throws Exception {
        UtilRSA.init();
        Cipher cipher = Cipher.getInstance("RSA/ECB/" + padding);
        cipher.init(2, keyFactory.generatePrivate(new PKCS8EncodedKeySpec(key)));
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] decryptByPublicKey(byte[] content, byte[] key, String padding) throws Exception {
        UtilRSA.init();
        Cipher cipher = Cipher.getInstance("RSA/ECB/" + padding);
        cipher.init(2, keyFactory.generatePublic(new X509EncodedKeySpec(key)));
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] encryptByPrivateKey(byte[] content, byte[] key, String padding) throws Exception {
        UtilRSA.init();
        Cipher cipher = Cipher.getInstance("RSA/ECB/" + padding);
        cipher.init(1, keyFactory.generatePrivate(new PKCS8EncodedKeySpec(key)));
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] encryptByPublicKey(byte[] content, byte[] key, String padding) throws Exception {
        UtilRSA.init();
        Cipher cipher = Cipher.getInstance("RSA/ECB/" + padding);
        cipher.init(1, keyFactory.generatePublic(new X509EncodedKeySpec(key)));
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static void main(String[] args) throws Exception {
        KeyPair keyPair = UtilRSA.generateKeyPair(2048);
        String content = "1";
        String string = UtilString.byteToHex(UtilRSA.encryptByPublicKey(content.getBytes(), keyPair.getPublic().getEncoded(), PADDING_OAEP_PADDING));
        byte[] bts = UtilRSA.decryptByPrivateKey(UtilString.hexStringToBytes(string), keyPair.getPrivate().getEncoded(), PADDING_OAEP_PADDING);
        System.out.println(string);
        System.out.println(new String(bts));
    }
}

