/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.crypto;

import com.sprite.utils.UtilString;
import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class Util3DES {
    private static String DEFAULT_MODEL = "ECB";
    private static String DEFAULT_PADDING = "PKCS5Padding";

    public static byte[] decrypt(byte[] content, byte[] keyByte, byte[] ivByte, String model, String padding) throws Exception {
        Cipher cipher = Cipher.getInstance(UtilString.place("DESede/{}/{}", model, padding));
        SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, "DESede");
        if ("ECB".equalsIgnoreCase(model) || ivByte == null) {
            cipher.init(2, sKeySpec);
        } else {
            cipher.init(2, (Key)sKeySpec, Util3DES.generateIV(ivByte));
        }
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] encrypt(byte[] content, byte[] keyByte, byte[] ivByte, String model, String padding) throws Exception {
        Cipher cipher = Cipher.getInstance(UtilString.place("DESede/{}/{}", model, padding));
        SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, "DESede");
        if ("ECB".equalsIgnoreCase(model) || ivByte == null) {
            cipher.init(1, sKeySpec);
        } else {
            cipher.init(1, (Key)sKeySpec, Util3DES.generateIV(ivByte));
        }
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] encrypt(byte[] content, byte[] keyByte, String model, String padding) throws Exception {
        return Util3DES.encrypt(content, keyByte, new byte[8], model, padding);
    }

    public static byte[] encrypt(byte[] content, byte[] keyByte, String model) throws Exception {
        return Util3DES.encrypt(content, keyByte, new byte[8], model, DEFAULT_PADDING);
    }

    public static byte[] encrypt(byte[] content, byte[] keyByte) throws Exception {
        return Util3DES.encrypt(content, keyByte, new byte[8], DEFAULT_MODEL, DEFAULT_PADDING);
    }

    public static byte[] decrypt(byte[] content, byte[] keyByte, String model, String padding) throws Exception {
        return Util3DES.decrypt(content, keyByte, new byte[8], model, padding);
    }

    public static byte[] decrypt(byte[] content, byte[] keyByte, String model) throws Exception {
        return Util3DES.decrypt(content, keyByte, new byte[8], model, DEFAULT_PADDING);
    }

    public static byte[] decrypt(byte[] content, byte[] keyByte) throws Exception {
        return Util3DES.decrypt(content, keyByte, new byte[8], DEFAULT_MODEL, DEFAULT_PADDING);
    }

    private static AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance("DESede");
        params.init(new IvParameterSpec(iv));
        return params;
    }
}

