/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.conversion;

import com.sprite.utils.conversion.ConversionException;
import com.sprite.utils.conversion.Converter;
import com.sprite.utils.conversion.ConverterLoader;
import com.sprite.utils.conversion.Converts;
import java.math.BigInteger;

public class LongConverters
implements ConverterLoader {
    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(LongConverters.class);
    }

    public static class IntegerToBaseLong
    implements Converter<Integer, Long> {
        @Override
        public Long convert(Integer source) throws ConversionException {
            if (source == null) {
                return 0L;
            }
            return source.longValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.TYPE;
        }
    }

    public static class IntegerToLong
    implements Converter<Integer, Long> {
        @Override
        public Long convert(Integer source) throws ConversionException {
            if (source == null) {
                return null;
            }
            return source.longValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    }

    public static class BigIntegerToLong
    implements Converter<BigInteger, Long> {
        @Override
        public Long convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.longValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    }

    public static class BigIntegerToBaseLong
    implements Converter<BigInteger, Long> {
        @Override
        public Long convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return 0L;
            }
            return obj.longValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.TYPE;
        }
    }

    public static class LongToBaseLong
    implements Converter<Long, Long> {
        @Override
        public Long convert(Long obj) throws ConversionException {
            if (obj == null) {
                return 0L;
            }
            return (long)obj;
        }

        @Override
        public Class<Long> getSourceClass() {
            return Long.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.TYPE;
        }
    }

    public static class StringToBaseLong
    implements Converter<String, Long> {
        @Override
        public Long convert(String obj) throws ConversionException {
            if (obj == null) {
                return 0L;
            }
            return Long.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.TYPE;
        }
    }

    public static class StringToLong
    implements Converter<String, Long> {
        @Override
        public Long convert(String obj) throws ConversionException {
            return Long.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Long> getTargetClass() {
            return Long.class;
        }
    }

    public static class LongToString
    implements Converter<Long, String> {
        @Override
        public String convert(Long obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.toString();
        }

        @Override
        public Class<Long> getSourceClass() {
            return Long.class;
        }

        @Override
        public Class<String> getTargetClass() {
            return String.class;
        }
    }
}

