/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.conversion;

import com.sprite.utils.UtilClass;
import com.sprite.utils.UtilMisc;
import com.sprite.utils.UtilString;
import com.sprite.utils.cache.UtilCache;
import com.sprite.utils.conversion.ConversionException;
import com.sprite.utils.conversion.Converter;
import com.sprite.utils.conversion.ConverterLoader;
import com.sprite.utils.conversion.StringConverter;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Converts {
    private static Logger logger = LoggerFactory.getLogger(Converts.class);
    private static final UtilCache<Converter<?, ?>> converterCache = UtilCache.createUtilCache("cache.converts");
    private static final String DELIMITER = "->";
    private static final StringConverter stringConverter;

    public static void loadContainedConverters(Class<?> containerClass) {
        for (Class<?> clz : containerClass.getClasses()) {
            if ((clz.getModifiers() & 0x400) != 0) continue;
            try {
                Object value = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(value instanceof Converter)) continue;
                Converts.registConverter((Converter)value);
            }
            catch (Exception e) {
                logger.warn("[loadContainedConverters] register converter fail, {}", containerClass);
            }
        }
    }

    public static void registConverter(Converter<?, ?> converter) throws ConversionException {
        Class primitiveClass;
        Class<?> sourceClass = converter.getSourceClass();
        Class<?> targetClass = converter.getTargetClass();
        if (sourceClass.isPrimitive()) {
            throw new ConversionException(" source class should not be primitive");
        }
        if (targetClass.isPrimitive() && converter.convert(null) == null) {
            throw new ConversionException(" target class is primitive, the value should not be null of the convert return");
        }
        String key = Converts.getKey(sourceClass, targetClass);
        converterCache.put(key, converter);
        if (UtilClass.isPrimitiveTypeWrapClass(sourceClass) && (primitiveClass = UtilClass.getPrimitiveClassOfPrimitiveTypeWrapClass(sourceClass)) != null) {
            key = Converts.getKey(primitiveClass, targetClass);
            converterCache.put(key, converter);
        }
    }

    public static <S, T> Converter<S, T> getConverter(Class<S> sourceClass, Class<T> targetClass, Converter defaultConverter) {
        String key = Converts.getKey(sourceClass, targetClass);
        Converter converter = converterCache.get(key);
        if (converter == null) {
            converter = defaultConverter;
        }
        return converter;
    }

    public static <S, T> Converter<S, T> getConverter(Class<S> sourceClass, Class<T> targetClass) {
        return Converts.getConverter(sourceClass, targetClass, null);
    }

    public static <T> T convert(Object source, Class<T> targetClass) throws ConversionException {
        if (source == null) {
            return null;
        }
        if (targetClass.isAssignableFrom(source.getClass())) {
            return UtilMisc.cast(source);
        }
        Converter<?, T> converter = null;
        converter = String.class.isAssignableFrom(targetClass) ? Converts.getConverter(source.getClass(), targetClass, stringConverter) : Converts.getConverter(source.getClass(), targetClass);
        if (converter == null) {
            throw new ConversionException("unsupport convert \uff1a" + source.getClass() + DELIMITER + targetClass.getName());
        }
        return converter.convert(UtilMisc.cast(source));
    }

    public static <T> T convert(Object source, Class<T> targetClass, T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        if (targetClass.isAssignableFrom(source.getClass())) {
            return UtilMisc.cast(source);
        }
        Converter<?, T> converter = null;
        converter = String.class.isAssignableFrom(targetClass) ? Converts.getConverter(source.getClass(), targetClass, stringConverter) : Converts.getConverter(source.getClass(), targetClass);
        if (converter == null) {
            return defaultValue;
        }
        T value = null;
        try {
            value = converter.convert(UtilMisc.cast(source));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static <S, T, K extends S> T convert(Class<S> sourceClass, Class<T> targetClass, K source, T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        if (targetClass.isAssignableFrom(source.getClass())) {
            return UtilMisc.cast(source);
        }
        Converter<?, T> converter = null;
        converter = String.class.isAssignableFrom(targetClass) ? Converts.getConverter(source.getClass(), targetClass, stringConverter) : Converts.getConverter(source.getClass(), targetClass);
        if (converter == null) {
            return defaultValue;
        }
        T value = null;
        try {
            value = converter.convert(UtilMisc.cast(source));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static String getKey(Class<?> sourceClass, Class<?> targetClass) {
        return Converts.getKey(sourceClass.getName(), targetClass.getName());
    }

    private static String getKey(String sourceClassName, String targetClassName) {
        return UtilString.place("{}{}{}", sourceClassName, DELIMITER, targetClassName);
    }

    private Converts() {
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (ConverterLoader converterLoader : ServiceLoader.load(ConverterLoader.class, loader)) {
            converterLoader.loadConverters();
        }
        stringConverter = new StringConverter();
    }
}

