/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.cache;

import com.sprite.utils.cache.Cache;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class UtilCache<V>
implements Cache<V> {
    private ConcurrentHashMap<String, V> utilCacheTable = new ConcurrentHashMap();
    private String name;

    public static <V> UtilCache<V> createUtilCache(String cacheName) {
        return new UtilCache<V>(cacheName);
    }

    private UtilCache(String name) {
        this.name = name;
    }

    @Override
    public String getCacheName() {
        return this.name;
    }

    @Override
    public void put(String key, V value) {
        this.utilCacheTable.put(key, value);
    }

    @Override
    public V get(String key) {
        return this.utilCacheTable.get(key);
    }

    @Override
    public V putIfAbsent(String cacheKey, V v) {
        return this.utilCacheTable.putIfAbsent(cacheKey, v);
    }

    @Override
    public V remove(String cacheKey) {
        return this.utilCacheTable.remove(cacheKey);
    }

    public List<V> values() {
        return new LinkedList<V>(this.utilCacheTable.values());
    }
}

