/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils;

import java.util.Collection;

public final class UtilCollection {
    public static boolean isEmpty(Collection<?> collection) {
        return !UtilCollection.isNotEmpty(collection);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && collection.size() > 0;
    }

    public static <T> T first(Collection<T> collection) {
        return UtilCollection.at(collection, 0);
    }

    public static <T> T at(Collection<T> collection, int i) {
        return UtilCollection.at(collection, i, null);
    }

    public static <T> T at(Collection<T> collection, int i, T defaultValue) {
        if (collection == null) {
            return null;
        }
        if (i < 0) {
            i += collection.size();
        }
        for (T t : collection) {
            if (i == 0) {
                return t;
            }
            --i;
        }
        return defaultValue;
    }

    public static <T> int size(Collection<T> collection) {
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    private UtilCollection() {
    }
}

