/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils;

import com.sprite.utils.UtilClass;
import com.sprite.utils.UtilMisc;
import com.sprite.utils.UtilString;
import com.sprite.utils.UtilXml;
import com.sprite.utils.conversion.Converts;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class UtilBeans {
    public static <T> T instance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    @Deprecated
    public static boolean isBean(Class<?> clazz) {
        return UtilClass.isBean(clazz);
    }

    public static <T> T fromXml(Element element, Class<T> clazz) throws InstantiationException, IllegalAccessException {
        T t = UtilBeans.instance(clazz);
        List<Element> elements = UtilXml.childElementList(element);
        for (Element el : elements) {
            String propertyName = UtilBeans.adjustBeanPropertyName(el.getTagName());
            if (UtilXml.hasChildElement(el)) {
                Object value = UtilBeans.fromXml(element, UtilBeans.getPropertyType(clazz, propertyName));
                UtilBeans.setProperty(t, propertyName, value);
                continue;
            }
            Node node = el.getFirstChild();
            UtilBeans.setProperty(t, propertyName, node.getTextContent());
        }
        return t;
    }

    public static <T> T fromXml(String xmlString, Class<T> clazz) throws Exception {
        return UtilBeans.fromXml(UtilXml.readXmlDocument(xmlString).getDocumentElement(), clazz);
    }

    private static String adjustBeanPropertyName(String propertyName) {
        if (UtilString.isBlank(propertyName)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean underline = false;
        char[] chars = propertyName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '_') {
                underline = true;
                continue;
            }
            if (underline) {
                builder.append(Character.toUpperCase(chars[i]));
                underline = false;
                continue;
            }
            builder.append(chars[i]);
            underline = false;
        }
        if (builder.length() == 1) {
            return builder.toString().toUpperCase();
        }
        if (Character.isUpperCase(builder.charAt(1))) {
            builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        } else {
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        }
        return builder.toString();
    }

    public static void setProperty(Object obj, String propertyName, Object value) {
        try {
            PropertyDesc desc = new PropertyDesc(propertyName, obj.getClass());
            if (desc.getFront() == null) {
                desc.setValue(obj, value);
                return;
            }
            Method wm = desc.getFront().getWriteMethod();
            if (desc.getBack() == null) {
                if (value == null) {
                    wm.invoke(obj, value);
                } else {
                    Class<?> targetClass;
                    Class<?>[] clazzs = wm.getParameterTypes();
                    if (clazzs != null && clazzs.length == 1 && !(targetClass = clazzs[0]).equals(value.getClass()) && !targetClass.isAssignableFrom(value.getClass())) {
                        value = Converts.convert(value, targetClass);
                    }
                    desc.setValue(obj, value);
                }
            } else {
                Method rmMethod = desc.getFront().getReadMethod();
                Object target = rmMethod.invoke(obj, new Object[0]);
                if (target == null) {
                    target = desc.getFront().getPropertyType().newInstance();
                }
                UtilBeans.setProperty(target, desc.getBack(), value);
                desc.setValue(obj, target);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set value of property '" + propertyName + "' from source to target [" + obj.getClass() + "]", e);
        }
    }

    public static Object getProperty(Object obj, String propertyName) {
        try {
            PropertyDesc desc = new PropertyDesc(propertyName, obj.getClass());
            if (desc.getBack() == null) {
                return desc.getValue(obj);
            }
            Method rmMethod = desc.getFront().getReadMethod();
            Object target = rmMethod.invoke(obj, new Object[0]);
            if (target == null) {
                target = desc.getFront().getPropertyType().newInstance();
            }
            return UtilBeans.getProperty(target, desc.getBack());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get value of property '" + propertyName + "' from source to target", e);
        }
    }

    public static Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        try {
            PropertyDesc desc = new PropertyDesc(propertyName, clazz);
            if (desc.getBack() == null) {
                return desc.getType();
            }
            return UtilBeans.getPropertyType(desc.getType(), desc.getBack());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get value of property '" + propertyName + "' from source to target", e);
        }
    }

    public static void setProperties(Object obj, Map<String, Object> props) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            UtilBeans.setProperty(obj, entry.getKey(), entry.getValue());
        }
    }

    public static void copyProperties(Object source, String[] sourceProps, Object target, String[] targetProps) {
        if (sourceProps == null || sourceProps.length == 0 || targetProps == null || targetProps.length == 0) {
            throw new IllegalArgumentException("sourceProps targetProps is null");
        }
        if (sourceProps.length != targetProps.length) {
            throw new IllegalArgumentException("length is not same");
        }
        for (int i = 0; i < sourceProps.length; ++i) {
            String sourceProp = sourceProps[i];
            String targetProp = targetProps[i];
            Object value = UtilBeans.getProperty(source, sourceProp);
            if (value == null) continue;
            UtilBeans.setProperty(target, targetProp, value);
        }
    }

    public static Map<String, Object> toMapWithFilter(Object source, String[] sourceProps, String[] alias, FilterCallback filterCallback) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (sourceProps == null || sourceProps.length == 0) {
            throw new IllegalArgumentException("sourceProps  is null");
        }
        for (int i = 0; i < sourceProps.length; ++i) {
            String sourceProp = sourceProps[i];
            Object value = null;
            int index = sourceProp.indexOf("[]");
            if (index <= 0) {
                value = UtilBeans.getProperty(source, sourceProp);
            }
            if (filterCallback != null) {
                value = filterCallback.filter(sourceProp, value);
            }
            if (value == null) continue;
            String prop = sourceProp;
            if (alias != null && alias.length > i) {
                prop = alias[i];
            }
            result.put(prop, value);
        }
        return result;
    }

    public static Map<String, Object> toMap(Object source, String[] sourceProps, String[] alias) {
        return UtilBeans.toMapWithFilter(source, sourceProps, alias, null);
    }

    public static Map<String, Object> toMap(Object source) {
        return UtilBeans.toMap(source, true);
    }

    public static Map<String, Object> toMap(Object source, boolean ignoreNull) {
        if (Map.class.isInstance(source)) {
            return (Map)UtilMisc.cast(source);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(source.getClass(), 3);
            String field = null;
            Object value = null;
            for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                if ("class".equals(descriptor.getName())) continue;
                field = descriptor.getName();
                value = descriptor.getReadMethod().invoke(source, new Object[0]);
                if (!ignoreNull) {
                    map.put(field, value);
                    continue;
                }
                if (value == null) continue;
                map.put(field, value);
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("convert object to map error", e);
        }
    }

    public static Map<String, Object> toMap(Object source, String[] sourceProps) {
        return UtilBeans.toMap(source, sourceProps, null);
    }

    public static List<Map<String, Object>> toMap(Collection<?> source, String[] sourceProps, String[] alias, Map<String, Object> other, FilterCallback filterCallback) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        for (Object object : source) {
            Map<String, Object> map = UtilBeans.toMapWithFilter(object, sourceProps, alias, filterCallback);
            if (other != null) {
                map.putAll(other);
            }
            list.add(map);
        }
        return list;
    }

    public static List<Map<String, Object>> toMap(Collection<?> source, String[] sourceProps, String[] alias, Map<String, Object> other) {
        return UtilBeans.toMap(source, sourceProps, alias, null, null);
    }

    public static List<Map<String, Object>> toMap(Collection<?> source, String[] sourceProps, String[] alias) {
        return UtilBeans.toMap(source, sourceProps, alias, null);
    }

    public static List<Map<String, Object>> toMap(Collection<?> source, String[] sourceProps) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        for (Object object : source) {
            list.add(UtilBeans.toMap(object, sourceProps, null));
        }
        return list;
    }

    public static List<Object> toList(Collection<?> source, String prop) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Object object : source) {
            Object value = UtilBeans.getProperty(object, prop);
            list.add(value);
        }
        return list;
    }

    private UtilBeans() {
    }

    private static class PropertyDesc {
        public static final String SEPARATOR = ".";
        private PropertyDescriptor front;
        private String property;
        private String back;

        public PropertyDesc(String property, Class<?> clazz) throws IntrospectionException {
            int position = property.indexOf(SEPARATOR);
            if (position < 0) {
                this.property = property;
            } else {
                this.property = property.substring(0, position);
                this.back = property.substring(position + 1);
            }
            if (!Map.class.isAssignableFrom(clazz)) {
                this.front = new PropertyDescriptor(this.property, clazz);
            }
        }

        public PropertyDescriptor getFront() {
            return this.front;
        }

        public String getBack() {
            return this.back;
        }

        public Object getValue(Object obj) throws ReflectiveOperationException {
            if (Map.class.isInstance(obj)) {
                return ((Map)obj).get(this.property);
            }
            if (this.front != null) {
                return this.front.getReadMethod().invoke(obj, new Object[0]);
            }
            return null;
        }

        public void setValue(Object obj, Object value) throws ReflectiveOperationException {
            if (Map.class.isInstance(obj)) {
                ((Map)obj).put(this.property, value);
            }
            if (this.front != null) {
                this.front.getWriteMethod().invoke(obj, value);
            }
        }

        public Class<?> getType() {
            return this.front.getPropertyType();
        }
    }

    public static interface FilterCallback {
        public Object filter(String var1, Object var2);
    }
}

