/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.text;

import com.sprite.utils.text.TokenHandler;

public class GenericTokenParser {
    private final char[] openToekn;
    private final char[] closeToken;
    private TokenHandler handler;

    public GenericTokenParser(String openToken, String closeToken, TokenHandler handler) {
        this.openToekn = openToken.toCharArray();
        this.closeToken = closeToken.toCharArray();
        this.handler = handler;
    }

    public String parse(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        if (cs.length() == 0) {
            return "";
        }
        String text = null;
        text = String.class.isInstance(cs) ? (String)cs : cs.toString();
        StringBuilder builder = new StringBuilder();
        int offset = 0;
        char[] src = text.toCharArray();
        while (offset < src.length) {
            if ((offset = this.s(src, offset, this.openToekn, builder)) >= src.length) continue;
            int last = this.s(src, offset += this.openToekn.length, this.closeToken, null);
            if (last < src.length) {
                String pString = this.handler.handleToken(new String(src, offset, last - offset));
                builder.append(pString);
                offset = last + this.closeToken.length;
                continue;
            }
            offset = last;
        }
        return builder.toString();
    }

    private int s(char[] src, int offset, char[] token, StringBuilder builder) {
        int of;
        boolean isToken = true;
        for (of = offset; of < src.length; ++of) {
            isToken = true;
            for (int i = 0; i < token.length; ++i) {
                if (src[of + i] == token[i]) continue;
                isToken = false;
                break;
            }
            if (isToken) break;
            if (builder == null) continue;
            builder.append(src[of]);
        }
        return of;
    }

    public static void main(String[] args) {
        String text = "{}AAA{123}BBB{234}AAA{123}BBB{234}AAA{123}BBB{234}AAA{123}BBB{234}AAA{123}BBB{234}";
        long time = System.currentTimeMillis();
        String conts = new GenericTokenParser("{", "}", new TokenHandler(){

            @Override
            public String handleToken(String content) {
                return "?";
            }
        }).parse(text);
        System.out.println(conts);
        System.out.println(System.currentTimeMillis() - time);
    }
}

