/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.mimetype;

import com.sprite.utils.UtilArray;
import com.sprite.utils.UtilString;
import com.sprite.utils.text.InsensitiveString;
import java.util.LinkedHashMap;
import java.util.Map;

public class MimeType {
    private String mimeType;
    private String type;
    private String subtype;
    private LinkedHashMap<InsensitiveString, Object> parameter = new LinkedHashMap();

    public MimeType() {
    }

    public MimeType(String typStr) {
        this.init(typStr);
    }

    private void init(String contentType) {
        if (UtilString.isBlank(contentType)) {
            throw new IllegalArgumentException("mime type is null");
        }
        int index = (contentType = contentType.trim()).indexOf(59);
        if (index <= 0) {
            this.mimeType = contentType;
            String[] typs = UtilString.tokenizeToStringArray(this.mimeType, "/");
            this.type = UtilArray.at(typs, 0, null);
            this.subtype = UtilArray.at(typs, 0, null);
            return;
        }
        this.mimeType = contentType.substring(0, index);
        contentType = contentType.substring(index + 1).trim();
        String[] typs = UtilString.tokenizeToStringArray(this.mimeType, "/");
        this.type = UtilArray.at(typs, 0, null);
        this.subtype = UtilArray.at(typs, 0, null);
        char[] chs = contentType.toCharArray();
        boolean isValue = false;
        int indexStart = 0;
        int offset = 0;
        String key = null;
        String value = null;
        boolean startQuote = false;
        for (char ch : chs) {
            ++offset;
            if (!isValue & ch == '=') {
                key = new String(chs, indexStart, offset - 1);
                indexStart += offset;
                offset = 0;
                continue;
            }
            if (key == null) continue;
            if (!isValue) {
                if (ch != ' ') {
                    isValue = true;
                    offset = 1;
                    if (ch == '\"') {
                        ++indexStart;
                        startQuote = true;
                    }
                } else {
                    ++indexStart;
                }
            } else if (startQuote) {
                if (ch == '\"') {
                    value = new String(chs, indexStart, offset - 1);
                } else if (indexStart + offset == chs.length) {
                    value = new String(chs, indexStart, offset);
                }
            } else if (ch == ' ') {
                value = new String(chs, indexStart, offset - 1);
            } else if (indexStart + offset == chs.length) {
                value = new String(chs, indexStart, offset);
            }
            if (value == null) continue;
            this.putParam(key, value);
            key = null;
            value = null;
            isValue = false;
            startQuote = false;
            indexStart += offset;
            offset = 0;
        }
    }

    public void putParam(String key, Object value) {
        if (value == null) {
            return;
        }
        this.parameter.put(InsensitiveString.insensitive(key), value);
    }

    public String getParam(String key) {
        return this.toString(this.parameter.get(InsensitiveString.insensitive(key)));
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.init(mimeType);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String toString() {
        StringBuffer ct = new StringBuffer(this.mimeType);
        for (Map.Entry<InsensitiveString, Object> entry : this.parameter.entrySet()) {
            ct.append("; ").append(entry.getKey()).append("=\"").append(this.toString(entry.getValue())).append("\"");
        }
        return ct.toString();
    }

    private String toString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }
}

