/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http.payload;

import com.sprite.utils.UtilString;
import com.sprite.utils.http.ContentDisposition;
import com.sprite.utils.http.ContentType;
import com.sprite.utils.http.RequestPayload;
import com.sprite.utils.http.payload.SimpleData;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class MultipartData
implements RequestPayload {
    private ContentType contentType = new ContentType("multipart/form-data; boundary=---------------------------" + UUID.randomUUID().toString().replace("-", ""));
    public LinkedHashMap<String, Object> parameter = new LinkedHashMap();

    @Override
    public void writePayload(OutputStream outputStream) throws IOException {
        String boundary = "--" + this.contentType.getParam("boundary");
        ContentType contentType = null;
        StringBuilder stam = new StringBuilder();
        for (Map.Entry<String, Object> param : this.parameter.entrySet()) {
            ContentDisposition contentDisposition;
            RequestPayload payload;
            stam.setLength(0);
            outputStream.write(boundary.getBytes());
            outputStream.write("\n".getBytes());
            Object value = param.getValue();
            if (value instanceof MultipartData) {
                MultipartData multipartData = (MultipartData)value;
                payload = multipartData;
                contentType = multipartData.getContentType();
                multipartData.writePayload(outputStream);
                contentDisposition = new ContentDisposition("form-data; ");
                contentDisposition.putParam("name", param.getKey());
            } else {
                SimpleData simpleData = new SimpleData();
                payload = simpleData;
                simpleData.setData(value);
                contentType = simpleData.getContentType();
                contentDisposition = simpleData.getContentDisposition();
                if (contentDisposition == null) {
                    contentDisposition = new ContentDisposition("form-data; ");
                }
                contentDisposition.putParam("name", param.getKey());
                contentDisposition.setMediaType("form-data");
            }
            stam.append("Content-Disposition: ").append(contentDisposition.toString()).append("\n");
            if (contentType != null) {
                stam.append("Content-Type: ").append(contentType.toString()).append("\n");
            }
            stam.append("\n");
            outputStream.write(stam.toString().getBytes());
            payload.writePayload(outputStream);
            outputStream.write("\n".getBytes());
        }
        outputStream.write(UtilString.place("{0}--", boundary).getBytes());
    }

    public void putParam(String key, Object value) {
        if (value == null) {
            return;
        }
        this.parameter.put(key, value);
    }

    public Object getParam(String key) {
        return this.parameter.get(key);
    }

    @Override
    public ContentType getContentType() {
        return this.contentType;
    }

    public void setCharset(String charset) {
        this.contentType.putParam("charset", charset);
    }

    public String getCharset() {
        return this.contentType.getCharset();
    }
}

