/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.conversion;

import com.sprite.utils.conversion.ConversionException;
import com.sprite.utils.conversion.Converter;
import com.sprite.utils.conversion.ConverterLoader;
import com.sprite.utils.conversion.Converts;
import java.math.BigInteger;

public class DoubleConverters
implements ConverterLoader {
    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(DoubleConverters.class);
    }

    public static class StringToBaseDouble
    implements Converter<String, Double> {
        @Override
        public Double convert(String obj) throws ConversionException {
            return Double.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.TYPE;
        }
    }

    public static class StringToDouble
    implements Converter<String, Double> {
        @Override
        public Double convert(String obj) throws ConversionException {
            return Double.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.class;
        }
    }

    public static class IntegerToBaseDouble
    implements Converter<Integer, Double> {
        @Override
        public Double convert(Integer obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.TYPE;
        }
    }

    public static class IntegerToDouble
    implements Converter<Integer, Double> {
        @Override
        public Double convert(Integer obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.class;
        }
    }

    public static class BigIntegerToBaseDouble
    implements Converter<BigInteger, Double> {
        @Override
        public Double convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.TYPE;
        }
    }

    public static class BigIntegerToDouble
    implements Converter<BigInteger, Double> {
        @Override
        public Double convert(BigInteger obj) throws ConversionException {
            if (obj == null) {
                return null;
            }
            return obj.doubleValue();
        }

        @Override
        public Class<BigInteger> getSourceClass() {
            return BigInteger.class;
        }

        @Override
        public Class<Double> getTargetClass() {
            return Double.class;
        }
    }
}

