/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.conversion;

import com.sprite.utils.UtilMisc;
import com.sprite.utils.cache.UtilCache;
import com.sprite.utils.conversion.ConversionException;
import com.sprite.utils.conversion.Converter;
import com.sprite.utils.conversion.ConverterLoader;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Converts {
    private static Logger logger = LoggerFactory.getLogger(Converts.class);
    private static final UtilCache<Converter<?, ?>> converterCache = UtilCache.createUtilCache("cache.converts");
    private static final String DELIMITER = "->";

    public static void loadContainedConverters(Class<?> containerClass) {
        for (Class<?> clz : containerClass.getClasses()) {
            if ((clz.getModifiers() & 0x400) != 0) continue;
            Object value = null;
            try {
                value = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error("error load converter ", (Throwable)e);
            }
            if (!(value instanceof Converter)) continue;
            Converts.registConverter(value);
        }
    }

    public static void registConverter(Converter<?, ?> converter) {
        String key = Converts.getKey(converter.getSourceClass(), converter.getTargetClass());
        converterCache.put(key, converter);
    }

    public static <S, T> Converter<S, T> getConverter(Class<S> sourceClass, Class<T> targetClass) {
        String key = Converts.getKey(sourceClass, targetClass);
        return (Converter)UtilMisc.cast(converterCache.get(key));
    }

    public static <T> T convert(Object source, Class<T> targetClass) throws ConversionException {
        if (source == null) {
            return null;
        }
        if (targetClass.isAssignableFrom(source.getClass())) {
            return UtilMisc.cast(source);
        }
        Converter<?, T> converter = Converts.getConverter(source.getClass(), targetClass);
        if (converter == null) {
            throw new ConversionException("unsupport convert \uff1a" + source.getClass() + DELIMITER + targetClass.getName());
        }
        return converter.convert(UtilMisc.cast(source));
    }

    public static <T> T convert(Object source, Class<T> targetClass, T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        Converter<?, T> converter = Converts.getConverter(source.getClass(), targetClass);
        if (converter == null) {
            return defaultValue;
        }
        T value = null;
        try {
            value = converter.convert(UtilMisc.cast(source));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static <S, T, K extends S> T convert(Class<S> sourceClass, Class<T> targetClass, K source, T defaultValue) {
        if (source == null) {
            return defaultValue;
        }
        Converter<S, T> converter = Converts.getConverter(sourceClass, targetClass);
        if (converter == null) {
            return defaultValue;
        }
        T value = null;
        try {
            value = converter.convert(UtilMisc.cast(source));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static String getKey(Class<?> sourceClass, Class<?> targetClass) {
        String key = sourceClass.getName().concat(DELIMITER).concat(targetClass.getName());
        return key;
    }

    private Converts() {
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (ConverterLoader converterLoader : ServiceLoader.load(ConverterLoader.class, loader)) {
            converterLoader.loadConverters();
        }
    }
}

