/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.conversion;

import com.sprite.utils.conversion.ConversionException;
import com.sprite.utils.conversion.Converter;
import com.sprite.utils.conversion.ConverterLoader;
import com.sprite.utils.conversion.Converts;

public class BooleanConverters
implements ConverterLoader {
    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(BooleanConverters.class);
    }

    public static class BaseBooleanToBoolean
    implements Converter<Boolean, Boolean> {
        @Override
        public Boolean convert(Boolean source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }
            return (boolean)source;
        }

        @Override
        public Class<Boolean> getSourceClass() {
            return Boolean.TYPE;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return Boolean.class;
        }
    }

    public static class BooleanToBaseBoolean
    implements Converter<Boolean, Boolean> {
        @Override
        public Boolean convert(Boolean source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }
            return (boolean)source;
        }

        @Override
        public Class<Boolean> getSourceClass() {
            return Boolean.class;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return Boolean.TYPE;
        }
    }

    public static class StringToBaseBoolean
    implements Converter<String, Boolean> {
        @Override
        public Boolean convert(String source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }
            source = source.trim();
            return Boolean.valueOf(source);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return Boolean.TYPE;
        }
    }

    public static class StringToBoolean
    implements Converter<String, Boolean> {
        @Override
        public Boolean convert(String source) throws ConversionException {
            if (source == null) {
                return Boolean.FALSE;
            }
            source = source.trim();
            return Boolean.valueOf(source);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Boolean> getTargetClass() {
            return Boolean.class;
        }
    }
}

