/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils;

import com.sprite.utils.UtilMisc;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilURL {
    private static final Logger logger = LoggerFactory.getLogger(UtilURL.class);

    public static <C> URL fromClass(Class<C> contextClass) {
        String resourceName = contextClass.getName();
        int dotIndex = resourceName.lastIndexOf(46);
        if (dotIndex != -1) {
            resourceName = resourceName.substring(0, dotIndex);
        }
        resourceName = resourceName + ".properties";
        return UtilURL.fromResource(contextClass, resourceName);
    }

    public static URL fromResource(String resourceName) {
        return UtilURL.fromResource(resourceName, null);
    }

    public static <C> URL fromResource(Class<C> contextClass, String resourceName) {
        if (contextClass == null) {
            return UtilURL.fromResource(resourceName, null);
        }
        return UtilURL.fromResource(resourceName, contextClass.getClassLoader());
    }

    public static URL fromResource(String resourceName, ClassLoader loader) {
        URL url;
        if (loader == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                UtilURL utilURL = new UtilURL();
                loader = utilURL.getClass().getClassLoader();
            }
        }
        if ((url = loader.getResource(resourceName)) != null) {
            return url;
        }
        String propertiesResourceName = null;
        if (!resourceName.endsWith(".properties") && (url = loader.getResource(propertiesResourceName = resourceName.concat(".properties"))) != null) {
            return url;
        }
        url = ClassLoader.getSystemResource(resourceName);
        if (url != null) {
            return url;
        }
        if (propertiesResourceName != null && (url = ClassLoader.getSystemResource(propertiesResourceName)) != null) {
            return url;
        }
        url = UtilURL.fromFilename(resourceName);
        if (url != null) {
            return url;
        }
        url = UtilURL.fromUrlString(resourceName);
        return url;
    }

    public static List<URL> fromResources(String resourceName) throws IOException {
        return UtilURL.fromResources(resourceName, null);
    }

    public static List<URL> fromResources(String resourceName, ClassLoader loader) throws IOException {
        LinkedList<URL> list;
        Enumeration<URL> enumeration;
        if (loader == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                UtilURL utilURL = new UtilURL();
                loader = utilURL.getClass().getClassLoader();
            }
        }
        if ((enumeration = loader.getResources(resourceName)) != null && enumeration.hasMoreElements()) {
            LinkedList<URL> list2 = new LinkedList<URL>();
            while (enumeration.hasMoreElements()) {
                URL url2 = enumeration.nextElement();
                list2.add(url2);
            }
            if (!list2.isEmpty()) {
                return list2;
            }
        }
        String propertiesResourceName = null;
        if (!resourceName.endsWith(".properties") && (enumeration = loader.getResources(propertiesResourceName = resourceName.concat(".properties"))) != null && enumeration.hasMoreElements()) {
            list = new LinkedList();
            while (enumeration.hasMoreElements()) {
                URL url2 = enumeration.nextElement();
                list.add(url2);
            }
            return list;
        }
        enumeration = ClassLoader.getSystemResources(resourceName);
        if (enumeration != null && enumeration.hasMoreElements()) {
            list = new LinkedList<URL>();
            while (enumeration.hasMoreElements()) {
                URL url2 = enumeration.nextElement();
                list.add(url2);
            }
            return list;
        }
        if (propertiesResourceName != null && (enumeration = ClassLoader.getSystemResources(propertiesResourceName)) != null && enumeration.hasMoreElements()) {
            list = new LinkedList();
            while (enumeration.hasMoreElements()) {
                URL url2 = enumeration.nextElement();
                list.add(url2);
            }
            return list;
        }
        URL url = UtilURL.fromFilename(resourceName);
        if (url != null) {
            return UtilMisc.toList(url);
        }
        url = UtilURL.fromUrlString(resourceName);
        if (url != null) {
            return UtilMisc.toList(url);
        }
        return Collections.emptyList();
    }

    public static URL fromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        URL url = null;
        try {
            if (file.exists()) {
                url = file.toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            logger.error("", (Throwable)e);
            url = null;
        }
        return url;
    }

    public static URL fromUrlString(String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    public static String readUrlText(URL url) throws IOException {
        InputStream stream = url.openStream();
        StringBuilder buf = new StringBuilder();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new InputStreamReader(stream));
            while ((str = in.readLine()) != null) {
                buf.append(str);
                buf.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
        return buf.toString();
    }
}

