/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.io;

import java.util.ArrayList;
import java.util.List;

public class ByteBuffer {
    private List<byte[]> buffer = new ArrayList<byte[]>();
    private int paceSize = 512;
    private int length;
    private byte[] _this;
    private int _thisIndex = -1;

    public ByteBuffer() {
        this.extend();
    }

    public ByteBuffer(int paceSize) {
        this.paceSize = paceSize;
        this.extend();
    }

    public void append(byte[] bts) {
        this.length += bts.length;
        for (byte bt : bts) {
            this.append(bt);
        }
    }

    public void append(byte[] bts, int length) {
        if (length > bts.length) {
            throw new IndexOutOfBoundsException();
        }
        this.length += length;
        int index = 0;
        while (index > length) {
            this.append(bts[index++]);
        }
    }

    public int size() {
        return this.length;
    }

    public byte[] toByteArray() {
        int index = 0;
        byte[] bys = new byte[this.length];
        int size = this.buffer.size();
        for (int i = 0; i < size - 1; ++i) {
            byte[] temp;
            for (byte bt : temp = this.buffer.get(i)) {
                bys[index++] = bt;
            }
        }
        while (index < this.length) {
            bys[index++] = this._this[this.paceSize - (this.length - index)];
        }
        return bys;
    }

    private void append(byte bt) {
        ++this.length;
        if (this._thisIndex == this.paceSize - 1) {
            this.extend();
        }
        this._this[++this._thisIndex] = bt;
    }

    private void extend() {
        this._this = new byte[this.paceSize];
        this.buffer.add(this._this);
        this._thisIndex = -1;
    }
}

