/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http;

import com.sprite.utils.UtilString;
import com.sprite.utils.http.ContentType;
import com.sprite.utils.http.DefaultHttpResponse;
import com.sprite.utils.http.Headers;
import com.sprite.utils.http.HttpException;
import com.sprite.utils.http.HttpResponse;
import com.sprite.utils.http.RequestPayload;
import com.sprite.utils.http.UrlParams;
import com.sprite.utils.io.UtilIO;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;

public class UtilHttp {
    private static Headers defaultHeaders = new Headers();

    private static String finalUrl(String url, UrlParams urlParam) throws UnsupportedEncodingException {
        if (urlParam == null || urlParam.size() == 0) {
            return url;
        }
        String paramCharset = urlParam.getCharset() != null ? urlParam.getCharset() : Charset.defaultCharset().name();
        url = url.trim();
        StringBuilder finalUrl = new StringBuilder(url);
        int i = -1;
        i = url.lastIndexOf(63);
        if (i < 0) {
            finalUrl.append("?");
        } else if (i > 0 && !url.endsWith("&")) {
            finalUrl.append('&');
        }
        if (urlParam != null && urlParam.size() > 0) {
            for (Map.Entry param : urlParam.entrySet()) {
                finalUrl.append((String)param.getKey()).append("=").append(URLEncoder.encode(UtilString.toString(param.getValue()), paramCharset)).append("&");
            }
            finalUrl.deleteCharAt(finalUrl.length() - 1);
        }
        return finalUrl.toString();
    }

    public static HttpResponse request(String url, String method, Headers headers, UrlParams urlParams, RequestPayload requestPayload) throws Exception {
        url = UtilHttp.finalUrl(url, urlParams);
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(url).openConnection();
        httpURLConnection.setRequestMethod(method);
        if (headers != null) {
            for (Map.Entry header : headers.entrySet()) {
                httpURLConnection.setRequestProperty((String)header.getKey(), UtilString.toString(header.getValue()));
            }
        }
        for (Map.Entry header : defaultHeaders.entrySet()) {
            httpURLConnection.setRequestProperty((String)header.getKey(), UtilString.toString(header.getValue()));
        }
        if (requestPayload != null) {
            httpURLConnection.setDoOutput(true);
            requestPayload.writePayload(httpURLConnection.getOutputStream());
        }
        return new DefaultHttpResponse(httpURLConnection);
    }

    public static HttpResponse get(String url) throws Exception {
        return UtilHttp.request(url, "GET", null, null, null);
    }

    public static InputStream getToStream(String url, Headers headers, UrlParams urlParams) throws Exception {
        HttpResponse response = UtilHttp.request(url, "GET", headers, urlParams, null);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType == null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return response.getInputStream();
    }

    public static InputStream getToStream(String url) throws Exception {
        return UtilHttp.getToStream(url, null, null);
    }

    public static byte[] getToByte(String url, Headers headers, UrlParams urlParams) throws Exception {
        InputStream inputStream = UtilHttp.getToStream(url, headers, urlParams);
        return UtilIO.readToBytes(inputStream);
    }

    public static byte[] getToByte(String url) throws Exception {
        return UtilHttp.getToByte(url, null, null);
    }

    public static String getToText(String url, Headers headers, UrlParams urlParams) throws Exception {
        HttpResponse response = UtilHttp.request(url, "GET", headers, urlParams, null);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType != null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return UtilIO.readToText(response.getInputStream(), charset);
    }

    public static String getToText(String url) throws Exception {
        return UtilHttp.getToText(url, null, null);
    }

    public static InputStream postToStream(String url, Headers headers, UrlParams urlParam, RequestPayload requestPayload) throws Exception {
        HttpResponse response = UtilHttp.request(url, "POST", headers, urlParam, requestPayload);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType == null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return response.getInputStream();
    }

    public static byte[] postToByte(String url, Headers headers, UrlParams urlParams, RequestPayload requestPayload) throws Exception {
        InputStream inputStream = UtilHttp.postToStream(url, headers, urlParams, requestPayload);
        return UtilIO.readToBytes(inputStream);
    }

    public static String postToText(String url, Headers headers, UrlParams urlParams, RequestPayload requestPayload) throws Exception {
        HttpResponse response = UtilHttp.request(url, "POST", headers, urlParams, requestPayload);
        String contentType = response.getHeader("Content-Type");
        String charset = null;
        if (contentType != null) {
            ContentType ctType = ContentType.resolve(contentType);
            charset = ctType.getCharset();
        }
        if (response.getStatusCode() != 200) {
            throw new HttpException(response.getStatusCode(), response.getStatusMessage(), UtilIO.readToText(response.getInputStream(), charset));
        }
        return UtilIO.readToText(response.getInputStream(), charset);
    }

    public static void main(String[] args) throws Exception {
        UtilHttp.getToText("https://www.cnblogs.com/skins/CodingLife/images/body_bg.png");
    }

    static {
        defaultHeaders.put("user-agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.119 Safari/537.36 SpriteUtilHttp/1.0");
    }
}

