/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.http;

public class ContentType {
    private String mediaType;
    private String charset;
    private String boundary;

    public ContentType(String content) {
        this.init(content);
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public void setBoundary(String boundary) {
        this.boundary = boundary;
    }

    private void init(String content) {
        int index = (content = content.trim()).indexOf(59);
        if (index < 0) {
            index = content.length();
        }
        this.mediaType = content.substring(0, index - 1);
        if (index >= content.length()) {
            return;
        }
        String[] strings = content.substring(index + 1).split("=");
        if (strings.length == 2) {
            if ("boundary".equals(strings[0])) {
                this.boundary = strings[1].trim();
            } else if ("charset".equals(strings[0])) {
                this.charset = strings[1].trim();
            }
        }
    }

    public String toContentTypeString() {
        StringBuffer ct = new StringBuffer(this.mediaType);
        if (this.boundary != null) {
            ct.append("; ").append("boundary=").append(this.boundary);
        } else if (this.charset != null) {
            ct.append("; ").append("charset=").append(this.charset);
        }
        return ct.toString();
    }

    public static ContentType resolve(String content) {
        return new ContentType(content);
    }

    public String toString() {
        return this.toContentTypeString();
    }
}

