/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.crypto;

import com.sprite.utils.UtilString;
import java.security.AlgorithmParameters;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class UtilDES {
    private static String DEFAULT_MODEL = "ECB";
    private static String DEFAULT_PADDING = "PKCS5Padding";

    public static byte[] decrypt(byte[] content, byte[] keyByte, byte[] ivByte, String model, String padding) throws Exception {
        Cipher cipher = Cipher.getInstance(UtilString.place("DES/{}/{}", model, padding));
        SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, "DES");
        if ("ECB".equalsIgnoreCase(model) || ivByte == null) {
            cipher.init(2, sKeySpec);
        } else {
            cipher.init(2, (Key)sKeySpec, UtilDES.generateIV(ivByte));
        }
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] encrypt(byte[] content, byte[] keyByte, byte[] ivByte, String model, String padding) throws Exception {
        Cipher cipher = Cipher.getInstance(UtilString.place("DES/{}/{}", model, padding));
        SecretKeySpec sKeySpec = new SecretKeySpec(keyByte, "DES");
        if ("ECB".equalsIgnoreCase(model) || ivByte == null) {
            cipher.init(1, sKeySpec);
        } else {
            cipher.init(1, (Key)sKeySpec, UtilDES.generateIV(ivByte));
        }
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static byte[] encrypt(byte[] content, byte[] keyByte) throws Exception {
        return UtilDES.encrypt(content, keyByte, new byte[8], DEFAULT_MODEL, DEFAULT_PADDING);
    }

    public static byte[] decrypt(byte[] content, byte[] keyByte, String model) throws Exception {
        return UtilDES.decrypt(content, keyByte, new byte[8], model, DEFAULT_PADDING);
    }

    public static byte[] decrypt(byte[] content, byte[] keyByte) throws Exception {
        return UtilDES.decrypt(content, keyByte, new byte[8], DEFAULT_MODEL, DEFAULT_PADDING);
    }

    private static AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance("DES");
        params.init(new IvParameterSpec(iv));
        return params;
    }
}

