/*
 * Decompiled with CFR 0.152.
 */
package com.sprite.utils.conversion;

import com.sprite.utils.conversion.ConversionException;
import com.sprite.utils.conversion.Converter;
import com.sprite.utils.conversion.ConverterLoader;
import com.sprite.utils.conversion.Converts;

public class IntegerConverters
implements ConverterLoader {
    @Override
    public void loadConverters() {
        Converts.loadContainedConverters(IntegerConverters.class);
    }

    public static class IntToInteger
    implements Converter<Integer, Integer> {
        @Override
        public Integer convert(Integer obj) throws ConversionException {
            return (int)obj;
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.TYPE;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return Integer.class;
        }
    }

    public static class IntegerToInt
    implements Converter<Integer, Integer> {
        @Override
        public Integer convert(Integer obj) throws ConversionException {
            return (int)obj;
        }

        @Override
        public Class<Integer> getSourceClass() {
            return Integer.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return Integer.TYPE;
        }
    }

    public static class StringToInt
    implements Converter<String, Integer> {
        @Override
        public Integer convert(String obj) throws ConversionException {
            return Integer.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return Integer.TYPE;
        }
    }

    public static class StringToInteger
    implements Converter<String, Integer> {
        @Override
        public Integer convert(String obj) throws ConversionException {
            return Integer.valueOf(obj);
        }

        @Override
        public Class<String> getSourceClass() {
            return String.class;
        }

        @Override
        public Class<Integer> getTargetClass() {
            return Integer.class;
        }
    }
}

